/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.activemq.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.openwire.v12.MarshallerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.wireformat.WireFormatFactory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ActiveMQProcessor {
    private static final String ACTIVEMQ_SERVICE_BASE = "META-INF/services/org/apache/activemq/";
    private static final String FEATURE = "camel-activemq";

    ActiveMQProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Socket.class.getName(), "sun.security.ssl.SSLSocketImpl", ActiveMQConnectionFactory.class.getName(), ActiveMQPrefetchPolicy.class.getName(), RedeliveryPolicy.class.getName(), BlobTransferPolicy.class.getName(), ConsumerInfo.class.getName(), org.apache.activemq.openwire.v9.MarshallerFactory.class.getName(), org.apache.activemq.openwire.v10.MarshallerFactory.class.getName(), org.apache.activemq.openwire.v11.MarshallerFactory.class.getName(), MarshallerFactory.class.getName()}).methods().build());
        IndexView index = combinedIndex.getIndex();
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])Stream.of(Transport.class, WireFormatFactory.class, DiscoveryAgent.class).map(DotName::createSimple).map(arg_0 -> ((IndexView)index).getAllKnownImplementors(arg_0)).flatMap(Collection::stream).map(ClassInfo::name).map(DotName::toString).toArray(String[]::new))).methods().build());
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.activemq", "activemq-client-jakarta"));
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        String[] servicePaths;
        for (String path : servicePaths = new String[]{"META-INF/services/org/apache/activemq/transport/discoveryagent/masterslave", "META-INF/services/org/apache/activemq/transport/discoveryagent/multicast", "META-INF/services/org/apache/activemq/transport/discoveryagent/simple", "META-INF/services/org/apache/activemq/transport/discoveryagent/static", "META-INF/services/org/apache/activemq/transport/failover", "META-INF/services/org/apache/activemq/transport/fanout", "META-INF/services/org/apache/activemq/transport/mock", "META-INF/services/org/apache/activemq/transport/multicast", "META-INF/services/org/apache/activemq/transport/nio", "META-INF/services/org/apache/activemq/transport/nio+ssl", "META-INF/services/org/apache/activemq/transport/ssl", "META-INF/services/org/apache/activemq/transport/tcp", "META-INF/services/org/apache/activemq/transport/udp", "META-INF/services/org/apache/activemq/wireformat/default"}) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{this.getServiceClass(path)}));
        }
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(servicePaths));
    }

    @BuildStep
    void runtimeReinitializedClasses(BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitializedClass) {
        runtimeReInitializedClass.produce((BuildItem)new RuntimeReinitializedClassBuildItem(IdGenerator.class.getName()));
    }

    private String getServiceClass(String servicePath) {
        String string;
        block8: {
            InputStream resource = ActiveMQProcessor.class.getClassLoader().getResourceAsStream(servicePath);
            try {
                Properties properties = new Properties();
                properties.load(resource);
                string = properties.getProperty("class");
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            resource.close();
        }
        return string;
    }
}

