/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.activemq.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.wireformat.WireFormatFactory;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ActiveMQProcessor {
    private static final String ACTIVEMQ_SERVICE_BASE = "META-INF/services/org/apache/activemq/";
    private static final DotName TRANSPORT = DotName.createSimple((String)Transport.class.getName());
    private static final DotName WIRE_FORMAT_FACTORY = DotName.createSimple((String)WireFormatFactory.class.getName());
    private static final DotName DISCOVERY_AGENT = DotName.createSimple((String)DiscoveryAgent.class.getName());
    private static final String FEATURE = "camel-activemq";

    ActiveMQProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection() {
        return new ReflectiveClassBuildItem(true, false, new String[]{"java.net.Socket", "sun.security.ssl.SSLSocketImpl", "org.apache.activemq.command.ConsumerInfo", "org.apache.activemq.pool.PooledConnectionFactory", "org.apache.commons.pool2.impl.DefaultEvictionPolicy", "org.apache.activemq.openwire.v2.MarshallerFactory", "org.apache.activemq.openwire.v3.MarshallerFactory", "org.apache.activemq.openwire.v4.MarshallerFactory", "org.apache.activemq.openwire.v5.MarshallerFactory", "org.apache.activemq.openwire.v6.MarshallerFactory", "org.apache.activemq.openwire.v7.MarshallerFactory", "org.apache.activemq.openwire.v8.MarshallerFactory", "org.apache.activemq.openwire.v9.MarshallerFactory", "org.apache.activemq.openwire.v10.MarshallerFactory", "org.apache.activemq.openwire.v11.MarshallerFactory", "org.apache.activemq.openwire.v12.MarshallerFactory"});
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.activemq", "activemq-client"));
    }

    @BuildStep
    ReflectiveClassBuildItem registerTransports(CombinedIndexBuildItem combinedIndex) {
        return new ReflectiveClassBuildItem(true, false, this.getReflectiveClass(combinedIndex, TRANSPORT));
    }

    @BuildStep
    ReflectiveClassBuildItem registerWireFormatFactory(CombinedIndexBuildItem combinedIndex) {
        return new ReflectiveClassBuildItem(true, false, this.getReflectiveClass(combinedIndex, WIRE_FORMAT_FACTORY));
    }

    @BuildStep
    ReflectiveClassBuildItem registerDiscoveryAgent(CombinedIndexBuildItem combinedIndex) {
        return new ReflectiveClassBuildItem(true, false, this.getReflectiveClass(combinedIndex, DISCOVERY_AGENT));
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        String[] servicePaths;
        for (String path : servicePaths = new String[]{"META-INF/services/org/apache/activemq/transport/discoveryagent/masterslave", "META-INF/services/org/apache/activemq/transport/discoveryagent/multicast", "META-INF/services/org/apache/activemq/transport/discoveryagent/simple", "META-INF/services/org/apache/activemq/transport/discoveryagent/static", "META-INF/services/org/apache/activemq/transport/failover", "META-INF/services/org/apache/activemq/transport/fanout", "META-INF/services/org/apache/activemq/transport/mock", "META-INF/services/org/apache/activemq/transport/multicast", "META-INF/services/org/apache/activemq/transport/nio", "META-INF/services/org/apache/activemq/transport/nio+ssl", "META-INF/services/org/apache/activemq/transport/ssl", "META-INF/services/org/apache/activemq/transport/tcp", "META-INF/services/org/apache/activemq/transport/udp", "META-INF/services/org/apache/activemq/wireformat/default"}) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{this.getServiceClass(path)}));
        }
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(servicePaths));
    }

    @BuildStep
    void runtimeReinitializedClasses(BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitializedClass) {
        runtimeReInitializedClass.produce((BuildItem)new RuntimeReinitializedClassBuildItem(IdGenerator.class.getName()));
    }

    private String getServiceClass(String servicePath) {
        String string;
        block8: {
            InputStream resource = ActiveMQProcessor.class.getClassLoader().getResourceAsStream(servicePath);
            try {
                Properties properties = new Properties();
                properties.load(resource);
                string = properties.getProperty("class");
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            resource.close();
        }
        return string;
    }

    private String[] getReflectiveClass(CombinedIndexBuildItem combinedIndex, DotName ifName) {
        IndexView index = combinedIndex.getIndex();
        return (String[])index.getAllKnownImplementors(ifName).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
    }
}

