/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.utils.SecurityUtils;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;

abstract class AbstractSalesforceMojo
extends AbstractMojo {
    private static final int DEFAULT_TIMEOUT = 60000;
    @Parameter(property="camelSalesforce.clientId", required=true)
    String clientId;
    @Parameter(property="camelSalesforce.clientSecret", required=true)
    String clientSecret;
    @Parameter
    Map<String, Object> httpClientProperties;
    @Parameter(property="camelSalesforce.httpProxyAuthUri")
    String httpProxyAuthUri;
    @Parameter(property="camelSalesforce.httpProxyExcludedAddresses")
    Set<String> httpProxyExcludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyHost")
    String httpProxyHost;
    @Parameter(property="camelSalesforce.httpProxyIncludedAddresses")
    Set<String> httpProxyIncludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyPassword")
    String httpProxyPassword;
    @Parameter(property="camelSalesforce.httpProxyPort")
    Integer httpProxyPort;
    @Parameter(property="camelSalesforce.httpProxyRealm")
    String httpProxyRealm;
    @Parameter(property="camelSalesforce.httpProxyUseDigestAuth")
    boolean httpProxyUseDigestAuth;
    @Parameter(property="camelSalesforce.httpProxyUsername")
    String httpProxyUsername;
    @Parameter(property="camelSalesforce.isHttpProxySecure")
    boolean isHttpProxySecure = true;
    @Parameter(property="camelSalesforce.isHttpProxySocks4")
    boolean isHttpProxySocks4;
    @Parameter(property="camelSalesforce.loginUrl", defaultValue="https://login.salesforce.com")
    String loginUrl;
    @Parameter(property="camelSalesforce.password", required=true)
    String password;
    @Parameter(property="camelSalesforce.sslContextParameters")
    final SSLContextParameters sslContextParameters = new SSLContextParameters();
    @Parameter(property="camelSalesforce.userName", required=true)
    String userName;
    @Parameter(property="camelSalesforce.version", defaultValue="34.0")
    String version;
    private long responseTimeout;

    AbstractSalesforceMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.setup();
        RestClient restClient = this.connectToSalesforce();
        try {
            this.executeWithClient(restClient);
        }
        finally {
            this.disconnectFromSalesforce(restClient);
        }
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    private RestClient connectToSalesforce() throws MojoExecutionException {
        DefaultRestClient restClient = null;
        try {
            SalesforceHttpClient httpClient = this.createHttpClient();
            this.getLog().info((CharSequence)"Logging in to Salesforce");
            SalesforceSession session = httpClient.getSession();
            try {
                session.login(null);
            }
            catch (SalesforceException e) {
                String msg = "Salesforce login error " + e.getMessage();
                throw new MojoExecutionException(msg, (Exception)((Object)e));
            }
            this.getLog().info((CharSequence)"Salesforce login successful");
            restClient = new DefaultRestClient(httpClient, this.version, PayloadFormat.JSON, session);
            restClient.start();
            return restClient;
        }
        catch (Exception e) {
            String msg = "Error connecting to Salesforce: " + e.getMessage();
            this.disconnectFromSalesforce((RestClient)restClient);
            throw new MojoExecutionException(msg, e);
        }
    }

    private SalesforceHttpClient createHttpClient() throws MojoExecutionException {
        SalesforceHttpClient httpClient;
        DefaultCamelContext camelContext = new DefaultCamelContext();
        try {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setSslContext(this.sslContextParameters.createSSLContext((CamelContext)camelContext));
            SecurityUtils.adaptToIBMCipherNames((SslContextFactory)sslContextFactory);
            httpClient = new SalesforceHttpClient(sslContextFactory);
        }
        catch (GeneralSecurityException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        httpClient.setConnectTimeout(60000L);
        httpClient.setTimeout(60000L);
        httpClient.setFollowRedirects(true);
        if (this.httpClientProperties != null && !this.httpClientProperties.isEmpty()) {
            try {
                PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)httpClient, new HashMap<String, Object>(this.httpClientProperties));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error setting HTTP client properties: " + e.getMessage(), e);
            }
        }
        this.responseTimeout = httpClient.getTimeout() + 1000L;
        if (this.httpProxyHost != null && this.httpProxyPort != null) {
            Origin.Address proxyAddress = new Origin.Address(this.httpProxyHost, this.httpProxyPort.intValue());
            Object proxy = this.isHttpProxySocks4 ? new Socks4Proxy(proxyAddress, this.isHttpProxySecure) : new HttpProxy(proxyAddress, this.isHttpProxySecure);
            if (this.httpProxyIncludedAddresses != null && !this.httpProxyIncludedAddresses.isEmpty()) {
                proxy.getIncludedAddresses().addAll(this.httpProxyIncludedAddresses);
            }
            if (this.httpProxyExcludedAddresses != null && !this.httpProxyExcludedAddresses.isEmpty()) {
                proxy.getExcludedAddresses().addAll(this.httpProxyExcludedAddresses);
            }
            httpClient.getProxyConfiguration().getProxies().add(proxy);
        }
        if (this.httpProxyUsername != null && this.httpProxyPassword != null) {
            StringHelper.notEmpty((String)this.httpProxyAuthUri, (String)"httpProxyAuthUri");
            StringHelper.notEmpty((String)this.httpProxyRealm, (String)"httpProxyRealm");
            Object authentication = this.httpProxyUseDigestAuth ? new DigestAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword) : new BasicAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword);
            httpClient.getAuthenticationStore().addAuthentication((Authentication)authentication);
        }
        SalesforceSession session = new SalesforceSession((CamelContext)new DefaultCamelContext(), httpClient, httpClient.getTimeout(), new SalesforceLoginConfig(this.loginUrl, this.clientId, this.clientSecret, this.userName, this.password, false));
        httpClient.setSession(session);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating HTTP client: " + e.getMessage(), e);
        }
        return httpClient;
    }

    private void disconnectFromSalesforce(RestClient restClient) {
        if (restClient == null) {
            return;
        }
        try {
            SalesforceHttpClient httpClient = (SalesforceHttpClient)((DefaultRestClient)restClient).getHttpClient();
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{restClient, httpClient.getSession(), httpClient});
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error stopping Salesforce HTTP client", (Throwable)e);
        }
    }

    protected abstract void executeWithClient(RestClient var1) throws MojoExecutionException;

    protected void setup() {
    }
}

