/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.PickListValue;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.maven.AbstractSalesforceMojo;
import org.apache.camel.maven.Defaults;
import org.apache.camel.maven.ObjectDescriptions;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.StringHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

@Mojo(name="generate", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractSalesforceMojo {
    public static final Map<String, String> DEFAULT_TYPES = GenerateMojo.defineLookupMap();
    private static final Set<String> BASE_FIELDS = GenerateMojo.defineBaseFields();
    private static final String BASE64BINARY = "base64Binary";
    private static final List<String> BLACKLISTED_PROPERTIES = Arrays.asList("PicklistValues", "ChildRelationships");
    private static final Pattern FIELD_DEFINITION_PATTERN = Pattern.compile("\\w+\\.{1}\\w+");
    private static final String JAVA_EXT = ".java";
    private static final Logger LOG = Logger.getLogger((String)GenerateMojo.class.getName());
    private static final String MULTIPICKLIST = "multipicklist";
    private static final String PACKAGE_NAME_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final String PICKLIST = "picklist";
    private static final String SOBJECT_LOOKUP_VM = "/sobject-lookup.vm";
    private static final String SOBJECT_PICKLIST_VM = "/sobject-picklist.vm";
    private static final String SOBJECT_POJO_OPTIONAL_VM = "/sobject-pojo-optional.vm";
    private static final String SOBJECT_POJO_VM = "/sobject-pojo.vm";
    private static final String SOBJECT_QUERY_RECORDS_OPTIONAL_VM = "/sobject-query-records-optional.vm";
    private static final String SOBJECT_QUERY_RECORDS_VM = "/sobject-query-records.vm";
    private static final String UTF_8 = "UTF-8";
    @Parameter
    Map<String, String> customTypes;
    ObjectDescriptions descriptions;
    VelocityEngine engine;
    @Parameter(property="camelSalesforce.includePattern")
    String includePattern;
    @Parameter(property="camelSalesforce.outputDirectory", defaultValue="${project.build.directory}/generated-sources/camel-salesforce")
    File outputDirectory;
    @Parameter(property="camelSalesforce.packageName", defaultValue="org.apache.camel.salesforce.dto")
    String packageName;
    @Parameter
    String[] picklistToEnums;
    @Parameter
    String[] picklistToStrings;
    @Parameter(property="camelSalesforce.useStringsForPicklists", defaultValue="false")
    Boolean useStringsForPicklists;
    @Parameter(property="camelSalesforce.excludePattern")
    private String excludePattern;
    @Parameter
    private String[] excludes;
    @Parameter
    private String[] includes;
    private final Map<String, Set<String>> picklistsEnumToSObject = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> picklistsStringToSObject = new HashMap<String, Set<String>>();
    private final Map<String, String> types = new HashMap<String, String>(DEFAULT_TYPES);
    @Parameter(property="camelSalesforce.useOptionals", defaultValue="false")
    private boolean useOptionals;

    void parsePicklistToEnums() {
        GenerateMojo.parsePicklistOverrideArgs(this.picklistToEnums, this.picklistsEnumToSObject);
    }

    void parsePicklistToStrings() {
        GenerateMojo.parsePicklistOverrideArgs(this.picklistToStrings, this.picklistsStringToSObject);
    }

    void processDescription(File pkgDir, SObjectDescription description, GeneratorUtility utility, String generatedDate) throws IOException {
        Throwable throwable;
        OutputStreamWriter writer;
        Serializable enumFile;
        this.parsePicklistToEnums();
        this.parsePicklistToStrings();
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)this.packageName);
        context.put("utility", (Object)utility);
        context.put("esc", StringEscapeUtils.class);
        context.put("desc", (Object)description);
        context.put("generatedDate", (Object)generatedDate);
        context.put("useStringsForPicklists", (Object)this.useStringsForPicklists);
        String pojoFileName = description.getName() + JAVA_EXT;
        File pojoFile = new File(pkgDir, pojoFileName);
        context.put("descriptions", (Object)this.descriptions);
        try (OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(pojoFile), StandardCharsets.UTF_8);){
            Template pojoTemplate = this.engine.getTemplate(SOBJECT_POJO_VM, UTF_8);
            pojoTemplate.merge((Context)context, (Writer)writer2);
        }
        if (this.useOptionals) {
            String optionalFileName = description.getName() + "Optional" + JAVA_EXT;
            File optionalFile = new File(pkgDir, optionalFileName);
            OutputStreamWriter writer3 = new OutputStreamWriter((OutputStream)new FileOutputStream(optionalFile), StandardCharsets.UTF_8);
            Object object = null;
            try {
                Template optionalTemplate = this.engine.getTemplate(SOBJECT_POJO_OPTIONAL_VM, UTF_8);
                optionalTemplate.merge((Context)context, (Writer)writer3);
            }
            catch (Throwable optionalTemplate) {
                object = optionalTemplate;
                throw optionalTemplate;
            }
            finally {
                if (writer3 != null) {
                    if (object != null) {
                        try {
                            ((Writer)writer3).close();
                        }
                        catch (Throwable optionalTemplate) {
                            ((Throwable)object).addSuppressed(optionalTemplate);
                        }
                    } else {
                        ((Writer)writer3).close();
                    }
                }
            }
        }
        HashSet<String> generatedLookupObjects = new HashSet<String>();
        for (SObjectField field : description.getFields()) {
            if (!utility.isLookup(field)) continue;
            for (String reference : field.getReferenceTo()) {
                List<SObjectField> externalIds = this.descriptions.externalIdsOf(reference);
                String lookupClassName = reference + "_Lookup";
                if (generatedLookupObjects.contains(lookupClassName)) continue;
                for (SObjectField externalId : externalIds) {
                    generatedLookupObjects.add(lookupClassName);
                    String lookupClassFileName = lookupClassName + JAVA_EXT;
                    File lookupClassFile = new File(pkgDir, lookupClassFileName);
                    context.put("field", (Object)externalId);
                    context.put("lookupRelationshipName", (Object)field.getRelationshipName());
                    context.put("lookupType", (Object)lookupClassName);
                    context.put("externalIdsList", externalIds);
                    context.put("lookupClassName", (Object)lookupClassName);
                    context.put("type", (Object)reference);
                    OutputStreamWriter writer4 = new OutputStreamWriter((OutputStream)new FileOutputStream(lookupClassFile), StandardCharsets.UTF_8);
                    Throwable throwable2 = null;
                    try {
                        Template lookupClassTemplate = this.engine.getTemplate(SOBJECT_LOOKUP_VM, UTF_8);
                        lookupClassTemplate.merge((Context)context, (Writer)writer4);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (writer4 == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Writer)writer4).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Writer)writer4).close();
                    }
                }
            }
        }
        for (SObjectField field : description.getFields()) {
            if (!utility.isPicklist(field) && !utility.isMultiSelectPicklist(field)) continue;
            String enumName = utility.enumTypeName(description.getName(), field.getName());
            String enumFileName = enumName + JAVA_EXT;
            enumFile = new File(pkgDir, enumFileName);
            context.put("field", (Object)field);
            context.put("enumName", (Object)enumName);
            Template enumTemplate = this.engine.getTemplate(SOBJECT_PICKLIST_VM, UTF_8);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)enumFile), StandardCharsets.UTF_8);
            throwable = null;
            try {
                enumTemplate.merge((Context)context, (Writer)writer);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ((Writer)writer).close();
            }
        }
        String queryRecordsFileName = "QueryRecords" + description.getName() + JAVA_EXT;
        File queryRecordsFile = new File(pkgDir, queryRecordsFileName);
        Template queryTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_VM, UTF_8);
        OutputStreamWriter writer5 = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsFile), StandardCharsets.UTF_8);
        enumFile = null;
        try {
            queryTemplate.merge((Context)context, (Writer)writer5);
        }
        catch (Throwable enumTemplate) {
            enumFile = enumTemplate;
            throw enumTemplate;
        }
        finally {
            if (writer5 != null) {
                if (enumFile != null) {
                    try {
                        ((Writer)writer5).close();
                    }
                    catch (Throwable enumTemplate) {
                        ((Throwable)enumFile).addSuppressed(enumTemplate);
                    }
                } else {
                    ((Writer)writer5).close();
                }
            }
        }
        if (this.useOptionals) {
            String queryRecordsOptionalFileName = "QueryRecords" + description.getName() + "Optional" + JAVA_EXT;
            File queryRecordsOptionalFile = new File(pkgDir, queryRecordsOptionalFileName);
            Template queryRecordsOptionalTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_OPTIONAL_VM, UTF_8);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsOptionalFile), StandardCharsets.UTF_8);
            throwable = null;
            try {
                queryRecordsOptionalTemplate.merge((Context)context, (Writer)writer);
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
    }

    @Override
    protected void executeWithClient(RestClient client) throws MojoExecutionException {
        File pkgDir;
        this.descriptions = new ObjectDescriptions(client, this.getResponseTimeout(), this.includes, this.includePattern, this.excludes, this.excludePattern, this.getLog());
        this.engine = GenerateMojo.createVelocityEngine();
        if (!(this.engine.resourceExists(SOBJECT_POJO_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_VM) && this.engine.resourceExists(SOBJECT_POJO_OPTIONAL_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_OPTIONAL_VM))) {
            throw new MojoExecutionException("Velocity templates not found");
        }
        if (!this.packageName.matches(PACKAGE_NAME_PATTERN)) {
            throw new MojoExecutionException("Invalid package name " + this.packageName);
        }
        if (this.outputDirectory.getAbsolutePath().contains("$")) {
            this.outputDirectory = new File("generated-sources/camel-salesforce");
        }
        if (!(pkgDir = new File(this.outputDirectory, this.packageName.trim().replace('.', File.separatorChar))).exists() && !pkgDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create " + pkgDir);
        }
        this.getLog().info((CharSequence)"Generating Java Classes...");
        GeneratorUtility utility = new GeneratorUtility();
        String generatedDate = new Date().toString();
        for (SObjectDescription description : this.descriptions.fetched()) {
            if (Defaults.IGNORED_OBJECTS.contains(description.getName())) continue;
            try {
                this.processDescription(pkgDir, description, utility, generatedDate);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to generate source files for: " + description.getName(), (Exception)e);
            }
        }
        this.getLog().info((CharSequence)String.format("Successfully generated %s Java Classes", this.descriptions.count() * 2));
    }

    @Override
    protected void setup() {
        if (this.customTypes != null) {
            this.types.putAll(this.customTypes);
        }
    }

    static VelocityEngine createVelocityEngine() {
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("resource.loader", "cloader");
        velocityProperties.setProperty("cloader.resource.loader.class", ClasspathResourceLoader.class.getName());
        velocityProperties.setProperty("runtime.log.name", LOG.getName());
        VelocityEngine engine = new VelocityEngine(velocityProperties);
        return engine;
    }

    private static Set<String> defineBaseFields() {
        HashSet<String> baseFields = new HashSet<String>();
        for (Field field : AbstractSObjectBase.class.getDeclaredFields()) {
            baseFields.add(field.getName());
        }
        return baseFields;
    }

    private static Map<String, String> defineLookupMap() {
        String[][] typeMap = new String[][]{{"ID", "String"}, {"string", "String"}, {"integer", "java.math.BigInteger"}, {"int", "Integer"}, {"long", "Long"}, {"short", "Short"}, {"decimal", "java.math.BigDecimal"}, {"float", "Float"}, {"double", "Double"}, {"boolean", "Boolean"}, {"byte", "Byte"}, {BASE64BINARY, "String"}, {"unsignedInt", "Long"}, {"unsignedShort", "Integer"}, {"unsignedByte", "Short"}, {"dateTime", "java.time.ZonedDateTime"}, {"time", "java.time.OffsetTime"}, {"date", "java.time.LocalDate"}, {"g", "java.time.ZonedDateTime"}, {"anyType", "String"}, {"address", "org.apache.camel.component.salesforce.api.dto.Address"}, {"location", "org.apache.camel.component.salesforce.api.dto.GeoLocation"}, {"RelationshipReferenceTo", "String"}};
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        for (String[] entry : typeMap) {
            lookupMap.put(entry[0], entry[1]);
        }
        return Collections.unmodifiableMap(lookupMap);
    }

    private static void parsePicklistOverrideArgs(String[] picklists, Map<String, Set<String>> picklistsToSObject) {
        if (picklists != null && picklists.length > 0) {
            for (String picklist : picklists) {
                if (!FIELD_DEFINITION_PATTERN.matcher(picklist).matches()) {
                    throw new IllegalArgumentException("Invalid format provided for picklistFieldToEnum value - allowed format SObjectName.FieldName");
                }
                String[] strings = picklist.split("\\.");
                picklistsToSObject.putIfAbsent(strings[0], new HashSet());
                picklistsToSObject.get(strings[0]).add(strings[1]);
            }
        }
    }

    public class GeneratorUtility {
        private Stack<String> stack;
        private final Map<String, AtomicInteger> varNames = new HashMap<String, AtomicInteger>();

        public String current() {
            return this.stack.peek();
        }

        public String enumTypeName(String sObjectName, String name) {
            return sObjectName + "_" + (name.endsWith("__c") ? name.substring(0, name.length() - 3) : name) + "Enum";
        }

        public List<SObjectField> externalIdsOf(String name) {
            return GenerateMojo.this.descriptions.externalIdsOf(name);
        }

        public String getEnumConstant(String value) {
            StringBuilder result = new StringBuilder();
            boolean changed = false;
            if (!Character.isJavaIdentifierStart(value.charAt(0))) {
                result.append("_");
                changed = true;
            }
            for (char c : value.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
                changed = true;
            }
            return changed ? result.toString().toUpperCase() : value.toUpperCase();
        }

        public String getFieldType(SObjectDescription description, SObjectField field) {
            if (this.isPicklist(field)) {
                if (Boolean.TRUE.equals(GenerateMojo.this.useStringsForPicklists)) {
                    if (GenerateMojo.this.picklistsEnumToSObject.containsKey(description.getName()) && ((Set)GenerateMojo.this.picklistsEnumToSObject.get(description.getName())).contains(field.getName())) {
                        return this.enumTypeName(description.getName(), field.getName());
                    }
                    return String.class.getName();
                }
                if (GenerateMojo.this.picklistsStringToSObject.containsKey(description.getName()) && ((Set)GenerateMojo.this.picklistsStringToSObject.get(description.getName())).contains(field.getName())) {
                    return String.class.getName();
                }
                return this.enumTypeName(description.getName(), field.getName());
            }
            if (this.isMultiSelectPicklist(field)) {
                if (Boolean.TRUE.equals(GenerateMojo.this.useStringsForPicklists)) {
                    if (GenerateMojo.this.picklistsEnumToSObject.containsKey(description.getName()) && ((Set)GenerateMojo.this.picklistsEnumToSObject.get(description.getName())).contains(field.getName())) {
                        return this.enumTypeName(description.getName(), field.getName()) + "[]";
                    }
                    return String.class.getName() + "[]";
                }
                if (GenerateMojo.this.picklistsStringToSObject.containsKey(description.getName()) && ((Set)GenerateMojo.this.picklistsStringToSObject.get(description.getName())).contains(field.getName())) {
                    return String.class.getName() + "[]";
                }
                return this.enumTypeName(description.getName(), field.getName()) + "[]";
            }
            String soapType = field.getSoapType();
            String lookupType = soapType.substring(soapType.indexOf(58) + 1);
            String type = (String)GenerateMojo.this.types.get(lookupType);
            if (type == null) {
                GenerateMojo.this.getLog().warn((CharSequence)String.format("Unsupported field type `%s` in field `%s` of object `%s`", soapType, field.getName(), description.getName()));
                GenerateMojo.this.getLog().debug((CharSequence)("Currently known types:\n " + GenerateMojo.this.types.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\n"))));
            }
            return type;
        }

        public String getLookupRelationshipName(SObjectField field) {
            return StringHelper.notEmpty((String)field.getRelationshipName(), (String)"relationshipName", (Object)field.getName());
        }

        public List<PickListValue> getUniqueValues(SObjectField field) {
            if (field.getPicklistValues().isEmpty()) {
                return field.getPicklistValues();
            }
            ArrayList<PickListValue> result = new ArrayList<PickListValue>();
            HashSet<String> literals = new HashSet<String>();
            for (PickListValue listValue : field.getPicklistValues()) {
                String value = listValue.getValue();
                if (literals.contains(value)) continue;
                literals.add(value);
                result.add(listValue);
            }
            literals.clear();
            Collections.sort(result, (o1, o2) -> o1.getValue().compareTo(o2.getValue()));
            return result;
        }

        public boolean hasExternalIds(String name) {
            return GenerateMojo.this.descriptions.hasExternalIds(name);
        }

        public boolean hasMultiSelectPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isMultiSelectPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean includeList(List<?> list, String propertyName) {
            return !list.isEmpty() && !BLACKLISTED_PROPERTIES.contains(propertyName);
        }

        public boolean isBlobField(SObjectField field) {
            String soapType = field.getSoapType();
            return GenerateMojo.BASE64BINARY.equals(soapType.substring(soapType.indexOf(58) + 1));
        }

        public boolean isExternalId(SObjectField field) {
            return field.isExternalId();
        }

        public boolean isLookup(SObjectField field) {
            return "reference".equals(field.getType());
        }

        public boolean isMultiSelectPicklist(SObjectField field) {
            return GenerateMojo.MULTIPICKLIST.equals(field.getType());
        }

        public boolean isPicklist(SObjectField field) {
            return GenerateMojo.PICKLIST.equals(field.getType());
        }

        public boolean isPrimitiveOrBoxed(Object object) {
            Class<?> clazz = object.getClass();
            boolean isWholeNumberWrapper = Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz);
            boolean isFloatingPointWrapper = Double.class.equals(clazz) || Float.class.equals(clazz);
            boolean isWrapper = isWholeNumberWrapper || isFloatingPointWrapper || Boolean.class.equals(clazz) || Character.class.equals(clazz);
            boolean isPrimitive = clazz.isPrimitive();
            return isPrimitive || isWrapper;
        }

        public boolean notBaseField(String name) {
            return !BASE_FIELDS.contains(name);
        }

        public boolean notNull(Object val) {
            return val != null;
        }

        public void pop() {
            this.stack.pop();
        }

        public Set<Map.Entry<String, Object>> propertiesOf(Object object) {
            TreeMap properties = new TreeMap();
            IntrospectionSupport.getProperties((Object)object, properties, null, (boolean)false);
            Function<Map.Entry, String> keyMapper = e -> StringUtils.capitalize((String)((String)e.getKey()));
            Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
            BinaryOperator mergeFunction = (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            };
            Supplier<Map> mapSupplier = LinkedHashMap::new;
            return properties.entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)).entrySet();
        }

        public void push(String additional) {
            this.stack.push(additional);
        }

        public void start(String initial) {
            this.stack = new Stack();
            this.stack.push(initial);
            this.varNames.clear();
        }

        public String variableName(String given) {
            String base = StringUtils.uncapitalize((String)given);
            AtomicInteger counter = this.varNames.get(base);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.varNames.put(base, counter);
            }
            return base + counter.incrementAndGet();
        }
    }
}

