/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.maven.AbstractSalesforceMojo;
import org.apache.camel.maven.Defaults;
import org.apache.camel.maven.ObjectDescriptions;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="schema", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SchemaMojo
extends AbstractSalesforceMojo {
    @Parameter(property="camelSalesforce.excludePattern")
    String excludePattern;
    @Parameter
    String[] excludes;
    @Parameter(property="camelSalesforce.includePattern")
    String includePattern;
    @Parameter
    String[] includes;
    @Parameter(property="camelSalesforce.jsonSchemaFilename", defaultValue="salesforce-dto-schema.json")
    String jsonSchemaFilename;
    @Parameter(property="camelSalesforce.jsonSchemaId", defaultValue="urn:jsonschema:org:apache:camel:component:salesforce:dto")
    String jsonSchemaId;
    @Parameter(property="camelSalesforce.outputDirectory", defaultValue="${project.build.directory}/generated-sources/camel-salesforce")
    File outputDirectory;

    @Override
    protected void executeWithClient(RestClient client) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating JSON Schema...");
        ObjectDescriptions descriptions = new ObjectDescriptions(client, this.getResponseTimeout(), this.includes, this.includePattern, this.excludes, this.excludePattern, this.getLog());
        ObjectMapper schemaObjectMapper = JsonUtils.createSchemaObjectMapper();
        HashSet allSchemas = new HashSet();
        for (SObjectDescription description : descriptions.fetched()) {
            if (Defaults.IGNORED_OBJECTS.contains(description.getName())) continue;
            try {
                allSchemas.addAll(JsonUtils.getSObjectJsonSchema((ObjectMapper)schemaObjectMapper, (SObjectDescription)description, (String)this.jsonSchemaId, (boolean)true));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to generate JSON Schema types for: " + description.getName(), (Exception)e);
            }
        }
        Path schemaFilePath = this.outputDirectory.toPath().resolve(this.jsonSchemaFilename);
        try {
            Files.write(schemaFilePath, JsonUtils.getJsonSchemaString((ObjectMapper)schemaObjectMapper, allSchemas, (String)this.jsonSchemaId).getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate JSON Schema source file: " + schemaFilePath, (Exception)e);
        }
        this.getLog().info((CharSequence)String.format("Successfully generated %s JSON Types in file %s", descriptions.count() * 2, schemaFilePath));
    }
}

