/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.SObject;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SyncResponseCallback;
import org.apache.camel.maven.Defaults;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

final class ObjectDescriptions {
    private final RestClient client;
    private final Map<String, SObjectDescription> descriptions = new ConcurrentHashMap<String, SObjectDescription>();
    private final long responseTimeout;

    ObjectDescriptions(RestClient client, long responseTimeout, String[] includes, String includePattern, String[] excludes, String excludePattern, Log log) throws MojoExecutionException {
        this.client = client;
        this.responseTimeout = responseTimeout;
        this.fetchSpecifiedDescriptions(includes, includePattern, excludes, excludePattern, log);
    }

    int count() {
        return this.descriptions.size();
    }

    SObjectDescription descriptionOf(String name) {
        return this.descriptions.computeIfAbsent(name, this::fetchDescriptionOf);
    }

    Iterable<SObjectDescription> fetched() {
        return this.descriptions.values();
    }

    private SObjectDescription fetchDescriptionOf(String name) {
        try {
            ObjectMapper mapper = JsonUtils.createObjectMapper();
            SyncResponseCallback callback = new SyncResponseCallback();
            this.client.getDescription(name, Collections.emptyMap(), (RestClient.ResponseCallback)callback);
            if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                throw new MojoExecutionException("Timeout waiting for getDescription for sObject " + name);
            }
            SalesforceException ex = callback.getException();
            if (ex != null) {
                throw ex;
            }
            SObjectDescription description = (SObjectDescription)mapper.readValue(callback.getResponse(), SObjectDescription.class);
            return description.prune();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error getting SObject description for '" + name + "': " + e.getMessage(), e);
        }
    }

    private void fetchSpecifiedDescriptions(String[] includes, String includePattern, String[] excludes, String excludePattern, Log log) throws MojoExecutionException {
        ObjectMapper mapper = JsonUtils.createObjectMapper();
        TreeSet<String> objectNames = new TreeSet<String>();
        SyncResponseCallback callback = new SyncResponseCallback();
        try {
            log.info((CharSequence)"Getting Salesforce Objects...");
            this.client.getGlobalObjects(Collections.emptyMap(), (RestClient.ResponseCallback)callback);
            if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                throw new MojoExecutionException("Timeout waiting for getGlobalObjects!");
            }
            SalesforceException ex = callback.getException();
            if (ex != null) {
                throw ex;
            }
            GlobalObjects globalObjects = (GlobalObjects)mapper.readValue(callback.getResponse(), GlobalObjects.class);
            for (SObject sObject : globalObjects.getSobjects()) {
                objectNames.add(sObject.getName());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error getting global Objects: " + e.getMessage(), e);
        }
        if (includes != null && includes.length > 0 || excludes != null && excludes.length > 0 || ObjectHelper.isNotEmpty((Object)includePattern) || ObjectHelper.isNotEmpty((Object)excludePattern)) {
            ObjectDescriptions.filterObjectNames(objectNames, includes, includePattern, excludes, excludePattern, log);
        } else {
            log.warn((CharSequence)String.format("Generating Java classes for all %s Objects, this may take a while...", objectNames.size()));
        }
        log.info((CharSequence)"Retrieving Object descriptions...");
        for (String name : objectNames) {
            this.descriptionOf(name);
        }
    }

    private static void filterObjectNames(Set<String> objectNames, String[] includes, String includePattern, String[] excludes, String excludePattern, Log log) throws MojoExecutionException {
        log.info((CharSequence)"Looking for matching Object names...");
        HashSet<String> includedNames = new HashSet<String>();
        if (includes != null && includes.length > 0) {
            for (String name : includes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in includes");
                }
                includedNames.add(name);
            }
        }
        HashSet<String> excludedNames = new HashSet<String>();
        if (excludes != null && excludes.length > 0) {
            for (String name : excludes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in excludes");
                }
                excludedNames.add(name);
            }
        }
        Pattern incPattern = includePattern != null && !includePattern.trim().isEmpty() ? Pattern.compile(includePattern.trim()) : (includedNames.isEmpty() ? Defaults.MATCH_EVERYTHING_PATTERN : Defaults.MATCH_NOTHING_PATTERN);
        Pattern excPattern = excludePattern != null && !excludePattern.trim().isEmpty() ? Pattern.compile(excludePattern.trim()) : Defaults.MATCH_NOTHING_PATTERN;
        HashSet<String> acceptedNames = new HashSet<String>();
        for (String name : objectNames) {
            if (!includedNames.contains(name) && !incPattern.matcher(name).matches() || excludedNames.contains(name) || excPattern.matcher(name).matches()) continue;
            acceptedNames.add(name);
        }
        objectNames.clear();
        objectNames.addAll(acceptedNames);
        log.info((CharSequence)String.format("Found %s matching Objects", objectNames.size()));
    }
}

