/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.PickListValue;
import org.apache.camel.component.salesforce.api.dto.SObject;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SyncResponseCallback;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@Mojo(name="generate", requiresProject=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CamelSalesforceMojo
extends AbstractMojo {
    protected static final int DEFAULT_TIMEOUT = 60000;
    private static final String UTF_8 = "UTF-8";
    private static final String JAVA_EXT = ".java";
    private static final String PACKAGE_NAME_PATTERN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern MATCH_EVERYTHING_PATTERN = Pattern.compile(".*");
    private static final Pattern MATCH_NOTHING_PATTERN = Pattern.compile("^$");
    private static final String SOBJECT_POJO_VM = "/sobject-pojo.vm";
    private static final String SOBJECT_POJO_OPTIONAL_VM = "/sobject-pojo-optional.vm";
    private static final String SOBJECT_QUERY_RECORDS_VM = "/sobject-query-records.vm";
    private static final String SOBJECT_QUERY_RECORDS_OPTIONAL_VM = "/sobject-query-records-optional.vm";
    private static final String SOBJECT_PICKLIST_VM = "/sobject-picklist.vm";
    private static final List<String> IGNORED_OBJECTS = Arrays.asList("FieldDefinition");
    private static final Logger LOG = Logger.getLogger((String)CamelSalesforceMojo.class.getName());
    @Parameter
    protected Map<String, Object> httpClientProperties;
    @Parameter(property="camelSalesforce.sslContextParameters")
    protected SSLContextParameters sslContextParameters;
    @Parameter(property="camelSalesforce.httpProxyHost")
    protected String httpProxyHost;
    @Parameter(property="camelSalesforce.httpProxyPort")
    protected Integer httpProxyPort;
    @Parameter(property="camelSalesforce.isHttpProxySocks4")
    protected boolean isHttpProxySocks4;
    @Parameter(property="camelSalesforce.isHttpProxySecure")
    protected boolean isHttpProxySecure = true;
    @Parameter(property="camelSalesforce.httpProxyIncludedAddresses")
    protected Set<String> httpProxyIncludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyExcludedAddresses")
    protected Set<String> httpProxyExcludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyUsername")
    protected String httpProxyUsername;
    @Parameter(property="camelSalesforce.httpProxyPassword")
    protected String httpProxyPassword;
    @Parameter(property="camelSalesforce.httpProxyAuthUri")
    protected String httpProxyAuthUri;
    @Parameter(property="camelSalesforce.httpProxyRealm")
    protected String httpProxyRealm;
    @Parameter(property="camelSalesforce.httpProxyUseDigestAuth")
    protected boolean httpProxyUseDigestAuth;
    @Parameter(property="camelSalesforce.clientId", required=true)
    protected String clientId;
    @Parameter(property="camelSalesforce.clientSecret", required=true)
    protected String clientSecret;
    @Parameter(property="camelSalesforce.userName", required=true)
    protected String userName;
    @Parameter(property="camelSalesforce.password", required=true)
    protected String password;
    @Parameter(property="camelSalesforce.version", defaultValue="34.0")
    protected String version;
    @Parameter(property="camelSalesforce.outputDirectory", defaultValue="${project.build.directory}/generated-sources/camel-salesforce")
    protected File outputDirectory;
    @Parameter(property="camelSalesforce.loginUrl", defaultValue="https://login.salesforce.com")
    protected String loginUrl;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(property="camelSalesforce.includePattern")
    protected String includePattern;
    @Parameter(property="camelSalesforce.excludePattern")
    protected String excludePattern;
    @Parameter(property="camelSalesforce.packageName", defaultValue="org.apache.camel.salesforce.dto")
    protected String packageName;
    @Parameter(property="camelSalesforce.useOptionals", defaultValue="false")
    protected boolean useOptionals;
    @Parameter(property="camelSalesforce.useStringsForPicklists", defaultValue="false")
    protected Boolean useStringsForPicklists;
    VelocityEngine engine;
    private long responseTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        DefaultRestClient restClient;
        this.engine = CamelSalesforceMojo.createVelocityEngine();
        if (!(this.engine.resourceExists(SOBJECT_POJO_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_VM) && this.engine.resourceExists(SOBJECT_POJO_OPTIONAL_VM) && this.engine.resourceExists(SOBJECT_QUERY_RECORDS_OPTIONAL_VM))) {
            throw new MojoExecutionException("Velocity templates not found");
        }
        SalesforceHttpClient httpClient = this.createHttpClient();
        SalesforceSession session = httpClient.getSession();
        this.getLog().info((CharSequence)"Salesforce login...");
        try {
            session.login(null);
        }
        catch (SalesforceException e) {
            String msg = "Salesforce login error " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)"Salesforce login successful");
        try {
            restClient = new DefaultRestClient(httpClient, this.version, PayloadFormat.JSON, session);
            restClient.start();
        }
        catch (Exception e) {
            String msg = "Unexpected exception creating Rest client: " + e.getMessage();
            throw new MojoExecutionException(msg, e);
        }
        try {
            File pkgDir;
            ObjectMapper mapper = JsonUtils.createObjectMapper();
            TreeSet<String> objectNames = new TreeSet<String>();
            SyncResponseCallback callback = new SyncResponseCallback();
            try {
                this.getLog().info((CharSequence)"Getting Salesforce Objects...");
                restClient.getGlobalObjects((RestClient.ResponseCallback)callback);
                if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                    throw new MojoExecutionException("Timeout waiting for getGlobalObjects!");
                }
                SalesforceException ex = callback.getException();
                if (ex != null) {
                    throw ex;
                }
                GlobalObjects globalObjects = (GlobalObjects)mapper.readValue(callback.getResponse(), GlobalObjects.class);
                for (SObject sObject : globalObjects.getSobjects()) {
                    objectNames.add(sObject.getName());
                }
            }
            catch (Exception e) {
                String msg = "Error getting global Objects: " + e.getMessage();
                throw new MojoExecutionException(msg, e);
            }
            if (this.includes != null && this.includes.length > 0 || this.excludes != null && this.excludes.length > 0 || ObjectHelper.isNotEmpty((Object)this.includePattern) || ObjectHelper.isNotEmpty((Object)this.excludePattern)) {
                this.filterObjectNames(objectNames);
            } else {
                this.getLog().warn((CharSequence)String.format("Generating Java classes for all %s Objects, this may take a while...", objectNames.size()));
            }
            HashSet<SObjectDescription> descriptions = new HashSet<SObjectDescription>();
            this.getLog().info((CharSequence)"Retrieving Object descriptions...");
            for (String name : objectNames) {
                try {
                    callback.reset();
                    restClient.getDescription(name, (RestClient.ResponseCallback)callback);
                    if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                        throw new MojoExecutionException("Timeout waiting for getDescription for sObject " + name);
                    }
                    SalesforceException ex = callback.getException();
                    if (ex != null) {
                        throw ex;
                    }
                    SObjectDescription description = (SObjectDescription)mapper.readValue(callback.getResponse(), SObjectDescription.class);
                    SObjectDescription descriptionToAdd = description.prune();
                    descriptions.add(descriptionToAdd);
                }
                catch (Exception e) {
                    String msg = "Error getting SObject description for '" + name + "': " + e.getMessage();
                    throw new MojoExecutionException(msg, e);
                }
            }
            if (!this.packageName.matches(PACKAGE_NAME_PATTERN)) {
                throw new MojoExecutionException("Invalid package name " + this.packageName);
            }
            if (this.outputDirectory.getAbsolutePath().contains("$")) {
                this.outputDirectory = new File("generated-sources/camel-salesforce");
            }
            if (!(pkgDir = new File(this.outputDirectory, this.packageName.trim().replace('.', File.separatorChar))).exists() && !pkgDir.mkdirs()) {
                throw new MojoExecutionException("Unable to create " + pkgDir);
            }
            this.getLog().info((CharSequence)"Generating Java Classes...");
            GeneratorUtility utility = new GeneratorUtility(this.useStringsForPicklists);
            String generatedDate = new Date().toString();
            for (SObjectDescription description : descriptions) {
                if (IGNORED_OBJECTS.contains(description.getName())) continue;
                try {
                    this.processDescription(pkgDir, description, utility, generatedDate);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to generate source files for: " + description.getName(), (Exception)e);
                }
            }
            this.getLog().info((CharSequence)String.format("Successfully generated %s Java Classes", descriptions.size() * 2));
        }
        finally {
            try {
                restClient.stop();
            }
            catch (Exception exception) {}
            try {
                session.stop();
            }
            catch (Exception exception) {}
            try {
                httpClient.stop();
            }
            catch (Exception exception) {}
        }
    }

    static VelocityEngine createVelocityEngine() {
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("resource.loader", "cloader");
        velocityProperties.setProperty("cloader.resource.loader.class", ClasspathResourceLoader.class.getName());
        velocityProperties.setProperty("runtime.log.logsystem.class", Log4JLogChute.class.getName());
        velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", LOG.getName());
        VelocityEngine engine = new VelocityEngine(velocityProperties);
        return engine;
    }

    protected void filterObjectNames(Set<String> objectNames) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Looking for matching Object names...");
        HashSet<String> includedNames = new HashSet<String>();
        if (this.includes != null && this.includes.length > 0) {
            for (String name : this.includes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in includes");
                }
                includedNames.add(name);
            }
        }
        HashSet<String> excludedNames = new HashSet<String>();
        if (this.excludes != null && this.excludes.length > 0) {
            for (String name : this.excludes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in excludes");
                }
                excludedNames.add(name);
            }
        }
        Pattern incPattern = this.includePattern != null && !this.includePattern.trim().isEmpty() ? Pattern.compile(this.includePattern.trim()) : (includedNames.isEmpty() ? MATCH_EVERYTHING_PATTERN : MATCH_NOTHING_PATTERN);
        Pattern excPattern = this.excludePattern != null && !this.excludePattern.trim().isEmpty() ? Pattern.compile(this.excludePattern.trim()) : MATCH_NOTHING_PATTERN;
        HashSet<String> acceptedNames = new HashSet<String>();
        for (String name : objectNames) {
            if (!includedNames.contains(name) && !incPattern.matcher(name).matches() || excludedNames.contains(name) || excPattern.matcher(name).matches()) continue;
            acceptedNames.add(name);
        }
        objectNames.clear();
        objectNames.addAll(acceptedNames);
        this.getLog().info((CharSequence)String.format("Found %s matching Objects", objectNames.size()));
    }

    protected SalesforceHttpClient createHttpClient() throws MojoExecutionException {
        SalesforceHttpClient httpClient;
        try {
            SSLContextParameters contextParameters = this.sslContextParameters != null ? this.sslContextParameters : new SSLContextParameters();
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setSslContext(contextParameters.createSSLContext());
            httpClient = new SalesforceHttpClient(sslContextFactory);
        }
        catch (GeneralSecurityException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        httpClient.setConnectTimeout(60000L);
        httpClient.setTimeout(60000L);
        httpClient.setFollowRedirects(true);
        if (this.httpClientProperties != null && !this.httpClientProperties.isEmpty()) {
            try {
                IntrospectionSupport.setProperties((Object)httpClient, new HashMap<String, Object>(this.httpClientProperties));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error setting HTTP client properties: " + e.getMessage(), e);
            }
        }
        this.responseTimeout = httpClient.getTimeout() + 1000L;
        if (this.httpProxyHost != null && this.httpProxyPort != null) {
            Origin.Address proxyAddress = new Origin.Address(this.httpProxyHost, this.httpProxyPort.intValue());
            Object proxy = this.isHttpProxySocks4 ? new Socks4Proxy(proxyAddress, this.isHttpProxySecure) : new HttpProxy(proxyAddress, this.isHttpProxySecure);
            if (this.httpProxyIncludedAddresses != null && !this.httpProxyIncludedAddresses.isEmpty()) {
                proxy.getIncludedAddresses().addAll(this.httpProxyIncludedAddresses);
            }
            if (this.httpProxyExcludedAddresses != null && !this.httpProxyExcludedAddresses.isEmpty()) {
                proxy.getExcludedAddresses().addAll(this.httpProxyExcludedAddresses);
            }
            httpClient.getProxyConfiguration().getProxies().add(proxy);
        }
        if (this.httpProxyUsername != null && this.httpProxyPassword != null) {
            ObjectHelper.notEmpty((String)this.httpProxyAuthUri, (String)"httpProxyAuthUri");
            ObjectHelper.notEmpty((String)this.httpProxyRealm, (String)"httpProxyRealm");
            Object authentication = this.httpProxyUseDigestAuth ? new DigestAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword) : new BasicAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword);
            httpClient.getAuthenticationStore().addAuthentication((Authentication)authentication);
        }
        SalesforceSession session = new SalesforceSession((CamelContext)new DefaultCamelContext(), httpClient, httpClient.getTimeout(), new SalesforceLoginConfig(this.loginUrl, this.clientId, this.clientSecret, this.userName, this.password, false));
        httpClient.setSession(session);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating HTTP client: " + e.getMessage(), e);
        }
        return httpClient;
    }

    void processDescription(File pkgDir, SObjectDescription description, GeneratorUtility utility, String generatedDate) throws IOException {
        Throwable throwable;
        OutputStreamWriter writer;
        Serializable enumFile;
        VelocityContext context = new VelocityContext();
        context.put("packageName", (Object)this.packageName);
        context.put("utility", (Object)utility);
        context.put("esc", StringEscapeUtils.class);
        context.put("desc", (Object)description);
        context.put("generatedDate", (Object)generatedDate);
        context.put("useStringsForPicklists", (Object)this.useStringsForPicklists);
        String pojoFileName = description.getName() + JAVA_EXT;
        File pojoFile = new File(pkgDir, pojoFileName);
        try (OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(pojoFile), StandardCharsets.UTF_8);){
            Template pojoTemplate = this.engine.getTemplate(SOBJECT_POJO_VM, UTF_8);
            pojoTemplate.merge((Context)context, (Writer)writer2);
        }
        if (this.useOptionals) {
            String optionalFileName = description.getName() + "Optional" + JAVA_EXT;
            File optionalFile = new File(pkgDir, optionalFileName);
            try (OutputStreamWriter writer3 = new OutputStreamWriter((OutputStream)new FileOutputStream(optionalFile), StandardCharsets.UTF_8);){
                Template optionalTemplate = this.engine.getTemplate(SOBJECT_POJO_OPTIONAL_VM, UTF_8);
                optionalTemplate.merge((Context)context, (Writer)writer3);
            }
        }
        for (SObjectField field : description.getFields()) {
            if (!utility.isPicklist(field) && !utility.isMultiSelectPicklist(field)) continue;
            String enumName = description.getName() + "_" + utility.enumTypeName(field.getName());
            String enumFileName = enumName + JAVA_EXT;
            enumFile = new File(pkgDir, enumFileName);
            context.put("field", (Object)field);
            context.put("enumName", (Object)enumName);
            Template enumTemplate = this.engine.getTemplate(SOBJECT_PICKLIST_VM, UTF_8);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)enumFile), StandardCharsets.UTF_8);
            throwable = null;
            try {
                enumTemplate.merge((Context)context, (Writer)writer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Writer)writer).close();
            }
        }
        String queryRecordsFileName = "QueryRecords" + description.getName() + JAVA_EXT;
        File queryRecordsFile = new File(pkgDir, queryRecordsFileName);
        Template queryTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_VM, UTF_8);
        OutputStreamWriter writer4 = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsFile), StandardCharsets.UTF_8);
        enumFile = null;
        try {
            queryTemplate.merge((Context)context, (Writer)writer4);
        }
        catch (Throwable enumTemplate) {
            enumFile = enumTemplate;
            throw enumTemplate;
        }
        finally {
            if (writer4 != null) {
                if (enumFile != null) {
                    try {
                        ((Writer)writer4).close();
                    }
                    catch (Throwable enumTemplate) {
                        ((Throwable)enumFile).addSuppressed(enumTemplate);
                    }
                } else {
                    ((Writer)writer4).close();
                }
            }
        }
        if (this.useOptionals) {
            String queryRecordsOptionalFileName = "QueryRecords" + description.getName() + "Optional" + JAVA_EXT;
            File queryRecordsOptionalFile = new File(pkgDir, queryRecordsOptionalFileName);
            Template queryRecordsOptionalTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_OPTIONAL_VM, UTF_8);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(queryRecordsOptionalFile), StandardCharsets.UTF_8);
            throwable = null;
            try {
                queryRecordsOptionalTemplate.merge((Context)context, (Writer)writer);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
    }

    public static class GeneratorUtility {
        private static final Set<String> BASE_FIELDS = new HashSet<String>();
        private static final Map<String, String> LOOKUP_MAP;
        private static final String BASE64BINARY = "base64Binary";
        private static final String MULTIPICKLIST = "multipicklist";
        private static final String PICKLIST = "picklist";
        private static final List<String> BLACKLISTED_PROPERTIES;
        private boolean useStringsForPicklists;
        private final Map<String, AtomicInteger> varNames = new HashMap<String, AtomicInteger>();
        private Stack<String> stack;

        public GeneratorUtility(Boolean useStringsForPicklists) {
            this.useStringsForPicklists = Boolean.TRUE.equals(useStringsForPicklists);
        }

        public boolean isBlobField(SObjectField field) {
            String soapType = field.getSoapType();
            return BASE64BINARY.equals(soapType.substring(soapType.indexOf(58) + 1));
        }

        public boolean notBaseField(String name) {
            return !BASE_FIELDS.contains(name);
        }

        public String getFieldType(SObjectDescription description, SObjectField field) throws MojoExecutionException {
            if (this.isPicklist(field)) {
                if (this.useStringsForPicklists) {
                    return String.class.getName();
                }
                return description.getName() + "_" + this.enumTypeName(field.getName());
            }
            if (this.isMultiSelectPicklist(field)) {
                if (this.useStringsForPicklists) {
                    return String.class.getName() + "[]";
                }
                return description.getName() + "_" + this.enumTypeName(field.getName()) + "[]";
            }
            String soapType = field.getSoapType();
            String type = LOOKUP_MAP.get(soapType.substring(soapType.indexOf(58) + 1));
            if (type == null) {
                throw new MojoExecutionException(String.format("Unsupported type %s for field %s", soapType, field.getName()));
            }
            return type;
        }

        public boolean isMultiSelectPicklist(SObjectField field) {
            return MULTIPICKLIST.equals(field.getType());
        }

        public boolean hasPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean hasMultiSelectPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isMultiSelectPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public List<PickListValue> getUniqueValues(SObjectField field) {
            if (field.getPicklistValues().isEmpty()) {
                return field.getPicklistValues();
            }
            ArrayList<PickListValue> result = new ArrayList<PickListValue>();
            HashSet<String> literals = new HashSet<String>();
            for (PickListValue listValue : field.getPicklistValues()) {
                String value = listValue.getValue();
                if (literals.contains(value)) continue;
                literals.add(value);
                result.add(listValue);
            }
            literals.clear();
            Collections.sort(result, new Comparator<PickListValue>(){

                @Override
                public int compare(PickListValue o1, PickListValue o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            return result;
        }

        public boolean isPicklist(SObjectField field) {
            return PICKLIST.equals(field.getType());
        }

        public String enumTypeName(String name) {
            name = name.endsWith("__c") ? name.substring(0, name.length() - 3) : name;
            return name + "Enum";
        }

        public String getEnumConstant(String value) {
            StringBuilder result = new StringBuilder();
            boolean changed = false;
            if (!Character.isJavaIdentifierStart(value.charAt(0))) {
                result.append("_");
                changed = true;
            }
            for (char c : value.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
                changed = true;
            }
            return changed ? result.toString().toUpperCase() : value.toUpperCase();
        }

        public boolean includeList(List<?> list, String propertyName) {
            return !list.isEmpty() && !BLACKLISTED_PROPERTIES.contains(propertyName);
        }

        public boolean notNull(Object val) {
            return val != null;
        }

        public Set<Map.Entry<String, Object>> propertiesOf(Object object) {
            HashMap properties = new HashMap();
            IntrospectionSupport.getProperties((Object)object, properties, null, (boolean)false);
            return properties.entrySet().stream().collect(Collectors.toMap(e -> StringUtils.capitalize((String)((String)e.getKey())), Map.Entry::getValue)).entrySet();
        }

        public String variableName(String given) {
            String base = StringUtils.uncapitalize((String)given);
            AtomicInteger counter = this.varNames.get(base);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.varNames.put(base, counter);
            }
            return base + counter.incrementAndGet();
        }

        public boolean isPrimitiveOrBoxed(Object object) {
            Class<?> clazz = object.getClass();
            boolean isWholeNumberWrapper = Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz);
            boolean isFloatingPointWrapper = Double.class.equals(clazz) || Float.class.equals(clazz);
            boolean isWrapper = isWholeNumberWrapper || isFloatingPointWrapper || Boolean.class.equals(clazz) || Character.class.equals(clazz);
            boolean isPrimitive = clazz.isPrimitive();
            return isPrimitive || isWrapper;
        }

        public void start(String initial) {
            this.stack = new Stack();
            this.stack.push(initial);
            this.varNames.clear();
        }

        public String current() {
            return this.stack.peek();
        }

        public void push(String additional) {
            this.stack.push(additional);
        }

        public void pop() {
            this.stack.pop();
        }

        static {
            for (Field field : AbstractSObjectBase.class.getDeclaredFields()) {
                BASE_FIELDS.add(field.getName());
            }
            String[][] typeMap = new String[][]{{"ID", "String"}, {"string", "String"}, {"integer", "java.math.BigInteger"}, {"int", "Integer"}, {"long", "Long"}, {"short", "Short"}, {"decimal", "java.math.BigDecimal"}, {"float", "Float"}, {"double", "Double"}, {"boolean", "Boolean"}, {"byte", "Byte"}, {"dateTime", "java.time.ZonedDateTime"}, {BASE64BINARY, "String"}, {"unsignedInt", "Long"}, {"unsignedShort", "Integer"}, {"unsignedByte", "Short"}, {"time", "java.time.ZonedDateTime"}, {"date", "java.time.ZonedDateTime"}, {"g", "java.time.ZonedDateTime"}, {"anyType", "String"}, {"address", "org.apache.camel.component.salesforce.api.dto.Address"}, {"location", "org.apache.camel.component.salesforce.api.dto.GeoLocation"}};
            LOOKUP_MAP = new HashMap<String, String>();
            for (String[] entry : typeMap) {
                LOOKUP_MAP.put(entry[0], entry[1]);
            }
            BLACKLISTED_PROPERTIES = Arrays.asList("PicklistValues", "ChildRelationships");
        }
    }
}

