/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.PickListValue;
import org.apache.camel.component.salesforce.api.dto.SObject;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.client.SyncResponseCallback;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CamelSalesforceMojo
extends AbstractMojo {
    protected static final int DEFAULT_TIMEOUT = 60000;
    private static final String JAVA_EXT = ".java";
    private static final String PACKAGE_NAME_PATTERN = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    private static final String SOBJECT_POJO_VM = "/sobject-pojo.vm";
    private static final String SOBJECT_QUERY_RECORDS_VM = "/sobject-query-records.vm";
    private static final String SOBJECT_PICKLIST_VM = "/sobject-picklist.vm";
    private static final Logger LOG = Logger.getLogger((String)CamelSalesforceMojo.class.getName());
    @Parameter
    protected Map<String, Object> httpClientProperties;
    @Parameter(property="camelSalesforce.sslContextParameters")
    protected SSLContextParameters sslContextParameters;
    @Parameter(property="camelSalesforce.httpProxyHost")
    protected String httpProxyHost;
    @Parameter(property="camelSalesforce.httpProxyPort")
    protected Integer httpProxyPort;
    @Parameter(property="camelSalesforce.isHttpProxySocks4")
    protected boolean isHttpProxySocks4;
    @Parameter(property="camelSalesforce.isHttpProxySecure")
    protected boolean isHttpProxySecure = true;
    @Parameter(property="camelSalesforce.httpProxyIncludedAddresses")
    protected Set<String> httpProxyIncludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyIncludedAddresses")
    protected Set<String> httpProxyExcludedAddresses;
    @Parameter(property="camelSalesforce.httpProxyUsername")
    protected String httpProxyUsername;
    @Parameter(property="camelSalesforce.httpProxyPassword")
    protected String httpProxyPassword;
    @Parameter(property="camelSalesforce.httpProxyAuthUri")
    protected String httpProxyAuthUri;
    @Parameter(property="camelSalesforce.httpProxyRealm")
    protected String httpProxyRealm;
    @Parameter(property="camelSalesforce.httpProxyUseDigestAuth")
    protected boolean httpProxyUseDigestAuth;
    @Parameter(property="camelSalesforce.clientId", required=true)
    protected String clientId;
    @Parameter(property="camelSalesforce.clientSecret", required=true)
    protected String clientSecret;
    @Parameter(property="camelSalesforce.userName", required=true)
    protected String userName;
    @Parameter(property="camelSalesforce.password", required=true)
    protected String password;
    @Parameter(property="camelSalesforce.version", defaultValue="33.0")
    protected String version;
    @Parameter(property="camelSalesforce.outputDirectory", defaultValue="${project.build.directory}/generated-sources/camel-salesforce")
    protected File outputDirectory;
    @Parameter(property="camelSalesforce.loginUrl", defaultValue="https://login.salesforce.com")
    protected String loginUrl;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(property="camelSalesforce.includePattern")
    protected String includePattern;
    @Parameter(property="camelSalesforce.excludePattern")
    protected String excludePattern;
    @Parameter(property="camelSalesforce.packageName", defaultValue="org.apache.camel.salesforce.dto")
    protected String packageName;
    private VelocityEngine engine;
    private long responseTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        DefaultRestClient restClient;
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("resource.loader", "cloader");
        velocityProperties.setProperty("cloader.resource.loader.class", ClasspathResourceLoader.class.getName());
        velocityProperties.setProperty("runtime.log.logsystem.class", Log4JLogChute.class.getName());
        velocityProperties.setProperty("runtime.log.logsystem.log4j.logger", LOG.getName());
        this.engine = new VelocityEngine(velocityProperties);
        this.engine.init();
        if (!this.engine.resourceExists(SOBJECT_POJO_VM) || !this.engine.resourceExists(SOBJECT_QUERY_RECORDS_VM)) {
            throw new MojoExecutionException("Velocity templates not found");
        }
        SalesforceHttpClient httpClient = this.createHttpClient();
        SalesforceSession session = httpClient.getSession();
        this.getLog().info((CharSequence)"Salesforce login...");
        try {
            session.login(null);
        }
        catch (SalesforceException e) {
            String msg = "Salesforce login error " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)"Salesforce login successful");
        try {
            restClient = new DefaultRestClient(httpClient, this.version, PayloadFormat.JSON, session);
            restClient.start();
        }
        catch (Exception e) {
            String msg = "Unexpected exception creating Rest client: " + e.getMessage();
            throw new MojoExecutionException(msg, e);
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            TreeSet<String> objectNames = new TreeSet<String>();
            SyncResponseCallback callback = new SyncResponseCallback();
            try {
                this.getLog().info((CharSequence)"Getting Salesforce Objects...");
                restClient.getGlobalObjects((RestClient.ResponseCallback)callback);
                if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                    throw new MojoExecutionException("Timeout waiting for getGlobalObjects!");
                }
                SalesforceException ex = callback.getException();
                if (ex != null) {
                    throw ex;
                }
                GlobalObjects globalObjects = (GlobalObjects)mapper.readValue(callback.getResponse(), GlobalObjects.class);
                for (SObject sObject : globalObjects.getSobjects()) {
                    objectNames.add(sObject.getName());
                }
            }
            catch (Exception e) {
                String msg = "Error getting global Objects " + e.getMessage();
                throw new MojoExecutionException(msg, e);
            }
            if (this.includes != null && this.includes.length > 0 || this.excludes != null && this.excludes.length > 0 || ObjectHelper.isNotEmpty((Object)this.includePattern) || ObjectHelper.isNotEmpty((Object)this.excludePattern)) {
                this.filterObjectNames(objectNames);
            } else {
                this.getLog().warn((CharSequence)String.format("Generating Java classes for all %s Objects, this may take a while...", objectNames.size()));
            }
            HashSet<Object> descriptions = new HashSet<Object>();
            this.getLog().info((CharSequence)"Retrieving Object descriptions...");
            for (String name : objectNames) {
                try {
                    callback.reset();
                    restClient.getDescription(name, (RestClient.ResponseCallback)callback);
                    if (!callback.await(this.responseTimeout, TimeUnit.MILLISECONDS)) {
                        throw new MojoExecutionException("Timeout waiting for getDescription for sObject " + name);
                    }
                    SalesforceException ex = callback.getException();
                    if (ex != null) {
                        throw ex;
                    }
                    descriptions.add(mapper.readValue(callback.getResponse(), SObjectDescription.class));
                }
                catch (Exception e) {
                    String msg = "Error getting SObject description for '" + name + "': " + e.getMessage();
                    throw new MojoExecutionException(msg, e);
                }
            }
            if (!this.packageName.matches(PACKAGE_NAME_PATTERN)) {
                throw new MojoExecutionException("Invalid package name " + this.packageName);
            }
            File pkgDir = new File(this.outputDirectory, this.packageName.trim().replace('.', File.separatorChar));
            if (!pkgDir.exists() && !pkgDir.mkdirs()) {
                throw new MojoExecutionException("Unable to create " + pkgDir);
            }
            this.getLog().info((CharSequence)"Generating Java Classes...");
            GeneratorUtility utility = new GeneratorUtility();
            String generatedDate = new Date().toString();
            for (SObjectDescription sObjectDescription : descriptions) {
                this.processDescription(pkgDir, sObjectDescription, utility, generatedDate);
            }
            this.getLog().info((CharSequence)String.format("Successfully generated %s Java Classes", descriptions.size() * 2));
        }
        finally {
            try {
                restClient.stop();
            }
            catch (Exception ignore) {}
            try {
                session.stop();
            }
            catch (Exception ignore) {}
            try {
                httpClient.stop();
            }
            catch (Exception ignore) {}
        }
    }

    protected void filterObjectNames(Set<String> objectNames) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Looking for matching Object names...");
        HashSet<String> includedNames = new HashSet<String>();
        if (this.includes != null && this.includes.length > 0) {
            for (String name : this.includes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in includes");
                }
                includedNames.add(name);
            }
        }
        HashSet<String> excludedNames = new HashSet<String>();
        if (this.excludes != null && this.excludes.length > 0) {
            for (String name : this.excludes) {
                if ((name = name.trim()).isEmpty()) {
                    throw new MojoExecutionException("Invalid empty name in excludes");
                }
                excludedNames.add(name);
            }
        }
        Pattern incPattern = this.includePattern != null && !this.includePattern.trim().isEmpty() ? Pattern.compile(this.includePattern.trim()) : (includedNames.isEmpty() ? Pattern.compile(".*") : Pattern.compile("^$"));
        Pattern excPattern = this.excludePattern != null && !this.excludePattern.trim().isEmpty() ? Pattern.compile(this.excludePattern.trim()) : Pattern.compile("^$");
        HashSet<String> acceptedNames = new HashSet<String>();
        for (String name : objectNames) {
            if (!includedNames.contains(name) && !incPattern.matcher(name).matches() || excludedNames.contains(name) || excPattern.matcher(name).matches()) continue;
            acceptedNames.add(name);
        }
        objectNames.clear();
        objectNames.addAll(acceptedNames);
        this.getLog().info((CharSequence)String.format("Found %s matching Objects", objectNames.size()));
    }

    protected SalesforceHttpClient createHttpClient() throws MojoExecutionException {
        SalesforceHttpClient httpClient;
        try {
            SSLContextParameters contextParameters = this.sslContextParameters != null ? this.sslContextParameters : new SSLContextParameters();
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setSslContext(contextParameters.createSSLContext());
            httpClient = new SalesforceHttpClient(sslContextFactory);
        }
        catch (GeneralSecurityException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating default SSL context: " + e.getMessage(), (Exception)e);
        }
        httpClient.setConnectTimeout(60000L);
        httpClient.setTimeout(60000L);
        httpClient.setFollowRedirects(true);
        if (this.httpClientProperties != null && !this.httpClientProperties.isEmpty()) {
            try {
                IntrospectionSupport.setProperties((Object)httpClient, new HashMap<String, Object>(this.httpClientProperties));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error setting HTTP client properties: " + e.getMessage(), e);
            }
        }
        this.responseTimeout = httpClient.getTimeout() + 1000L;
        if (this.httpProxyHost != null && this.httpProxyPort != null) {
            Origin.Address proxyAddress = new Origin.Address(this.httpProxyHost, this.httpProxyPort.intValue());
            Object proxy = this.isHttpProxySocks4 ? new Socks4Proxy(proxyAddress, this.isHttpProxySecure) : new HttpProxy(proxyAddress, this.isHttpProxySecure);
            if (this.httpProxyIncludedAddresses != null && !this.httpProxyIncludedAddresses.isEmpty()) {
                proxy.getIncludedAddresses().addAll(this.httpProxyIncludedAddresses);
            }
            if (this.httpProxyExcludedAddresses != null && !this.httpProxyExcludedAddresses.isEmpty()) {
                proxy.getExcludedAddresses().addAll(this.httpProxyExcludedAddresses);
            }
            httpClient.getProxyConfiguration().getProxies().add(proxy);
        }
        if (this.httpProxyUsername != null && this.httpProxyPassword != null) {
            ObjectHelper.notEmpty((String)this.httpProxyAuthUri, (String)"httpProxyAuthUri");
            ObjectHelper.notEmpty((String)this.httpProxyRealm, (String)"httpProxyRealm");
            Object authentication = this.httpProxyUseDigestAuth ? new DigestAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword) : new BasicAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword);
            httpClient.getAuthenticationStore().addAuthentication((Authentication)authentication);
        }
        SalesforceSession session = new SalesforceSession(httpClient, httpClient.getTimeout(), new SalesforceLoginConfig(this.loginUrl, this.clientId, this.clientSecret, this.userName, this.password, false));
        httpClient.setSession(session);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating HTTP client: " + e.getMessage(), e);
        }
        return httpClient;
    }

    private void processDescription(File pkgDir, SObjectDescription description, GeneratorUtility utility, String generatedDate) throws MojoExecutionException {
        String fileName = description.getName() + JAVA_EXT;
        BufferedWriter writer = null;
        try {
            File pojoFile = new File(pkgDir, fileName);
            writer = new BufferedWriter(new FileWriter(pojoFile));
            VelocityContext context = new VelocityContext();
            context.put("packageName", (Object)this.packageName);
            context.put("utility", (Object)utility);
            context.put("desc", (Object)description);
            context.put("generatedDate", (Object)generatedDate);
            Template pojoTemplate = this.engine.getTemplate(SOBJECT_POJO_VM);
            pojoTemplate.merge((Context)context, (Writer)writer);
            writer.close();
            for (SObjectField field : description.getFields()) {
                if (!utility.isPicklist(field) && !utility.isMultiSelectPicklist(field)) continue;
                fileName = utility.enumTypeName(field.getName()) + JAVA_EXT;
                File enumFile = new File(pkgDir, fileName);
                writer = new BufferedWriter(new FileWriter(enumFile));
                context = new VelocityContext();
                context.put("packageName", (Object)this.packageName);
                context.put("utility", (Object)utility);
                context.put("field", (Object)field);
                context.put("generatedDate", (Object)generatedDate);
                Template queryTemplate = this.engine.getTemplate(SOBJECT_PICKLIST_VM);
                queryTemplate.merge((Context)context, (Writer)writer);
                writer.close();
            }
            fileName = "QueryRecords" + description.getName() + JAVA_EXT;
            File queryFile = new File(pkgDir, fileName);
            writer = new BufferedWriter(new FileWriter(queryFile));
            context = new VelocityContext();
            context.put("packageName", (Object)this.packageName);
            context.put("desc", (Object)description);
            context.put("generatedDate", (Object)generatedDate);
            Template queryTemplate = this.engine.getTemplate(SOBJECT_QUERY_RECORDS_VM);
            queryTemplate.merge((Context)context, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            String msg = "Error creating " + fileName + ": " + e.getMessage();
            throw new MojoExecutionException(msg, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static class GeneratorUtility {
        private static final Set<String> BASE_FIELDS = new HashSet<String>();
        private static final Map<String, String> LOOKUP_MAP;
        private static final String BASE64BINARY = "base64Binary";
        private static final String MULTIPICKLIST = "multipicklist";
        private static final String PICKLIST = "picklist";

        public boolean isBlobField(SObjectField field) {
            String soapType = field.getSoapType();
            return BASE64BINARY.equals(soapType.substring(soapType.indexOf(58) + 1));
        }

        public boolean notBaseField(String name) {
            return !BASE_FIELDS.contains(name);
        }

        public String getFieldType(SObjectField field) throws MojoExecutionException {
            if (this.isPicklist(field)) {
                return this.enumTypeName(field.getName());
            }
            if (this.isMultiSelectPicklist(field)) {
                return this.enumTypeName(field.getName()) + "[]";
            }
            String soapType = field.getSoapType();
            String type = LOOKUP_MAP.get(soapType.substring(soapType.indexOf(58) + 1));
            if (type == null) {
                throw new MojoExecutionException(String.format("Unsupported type %s for field %s", soapType, field.getName()));
            }
            return type;
        }

        public boolean isMultiSelectPicklist(SObjectField field) {
            return MULTIPICKLIST.equals(field.getType());
        }

        public boolean hasPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public boolean hasMultiSelectPicklists(SObjectDescription desc) {
            for (SObjectField field : desc.getFields()) {
                if (!this.isMultiSelectPicklist(field)) continue;
                return true;
            }
            return false;
        }

        public List<PickListValue> getUniqueValues(SObjectField field) {
            if (field.getPicklistValues().isEmpty()) {
                return field.getPicklistValues();
            }
            ArrayList<PickListValue> result = new ArrayList<PickListValue>();
            HashSet<String> literals = new HashSet<String>();
            for (PickListValue listValue : field.getPicklistValues()) {
                String value = listValue.getValue();
                if (literals.contains(value)) continue;
                literals.add(value);
                result.add(listValue);
            }
            literals.clear();
            Collections.sort(result, new Comparator<PickListValue>(){

                @Override
                public int compare(PickListValue o1, PickListValue o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            return result;
        }

        public boolean isPicklist(SObjectField field) {
            return PICKLIST.equals(field.getType());
        }

        public String enumTypeName(String name) {
            name = name.endsWith("__c") ? name.substring(0, name.length() - 3) : name;
            return name + "Enum";
        }

        public String getEnumConstant(String value) {
            StringBuilder result = new StringBuilder();
            boolean changed = false;
            if (!Character.isJavaIdentifierStart(value.charAt(0))) {
                result.append("_");
                changed = true;
            }
            for (char c : value.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
                changed = true;
            }
            return changed ? result.toString().toUpperCase() : value.toUpperCase();
        }

        static {
            for (Field field : AbstractSObjectBase.class.getDeclaredFields()) {
                BASE_FIELDS.add(field.getName());
            }
            String[][] typeMap = new String[][]{{"ID", "String"}, {"string", "String"}, {"integer", "java.math.BigInteger"}, {"int", "Integer"}, {"long", "Long"}, {"short", "Short"}, {"decimal", "java.math.BigDecimal"}, {"float", "Float"}, {"double", "Double"}, {"boolean", "Boolean"}, {"byte", "Byte"}, {"dateTime", "org.joda.time.DateTime"}, {BASE64BINARY, "String"}, {"unsignedInt", "Long"}, {"unsignedShort", "Integer"}, {"unsignedByte", "Short"}, {"time", "org.joda.time.DateTime"}, {"date", "org.joda.time.DateTime"}, {"g", "org.joda.time.DateTime"}, {"anyType", "String"}, {"address", "org.apache.camel.component.salesforce.api.dto.Address"}, {"location", "org.apache.camel.component.salesforce.api.dto.GeoLocation"}};
            LOOKUP_MAP = new HashMap<String, String>();
            for (String[] entry : typeMap) {
                LOOKUP_MAP.put(entry[0], entry[1]);
            }
        }
    }
}

