/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.catalog;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.camelk.v1alpha1.Kamelet;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KameletsCatalog {
    static final String KAMELETS_DIR = "kamelets";
    private static final Logger LOG = LoggerFactory.getLogger(KameletsCatalog.class);
    private static final String KAMELETS_FILE_SUFFIX = ".kamelet.yaml";
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Map<String, Kamelet> kameletModels = KameletsCatalog.initCatalog();
    private final List<String> kameletNames = this.kameletModels.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());

    private static Map<String, Kamelet> initCatalog() {
        HashMap<String, Kamelet> kameletModels = new HashMap<String, Kamelet>();
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"/kamelets/"}).scan();){
            for (Resource resource : scanResult.getAllResources()) {
                try {
                    InputStream is = resource.open();
                    try {
                        String name = KameletsCatalog.sanitizeFileName(resource.getPath());
                        Kamelet kamelet = (Kamelet)MAPPER.readValue(is, Kamelet.class);
                        LOG.debug("Loading kamelet from: {}, path: {}, name: {}", new Object[]{resource.getClasspathElementFile(), resource.getPath(), name});
                        kameletModels.put(name, kamelet);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Cannot init Kamelet Catalog with content of " + resource.getPath(), (Throwable)e);
                }
            }
        }
        return Collections.unmodifiableMap(kameletModels);
    }

    private static String sanitizeFileName(String fileName) {
        int index = fileName.lastIndexOf(KAMELETS_FILE_SUFFIX);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName.substring(9);
    }

    public Map<String, Kamelet> getKamelets() {
        return this.kameletModels;
    }

    public List<String> getKameletsName() {
        return this.kameletNames;
    }

    public List<Kamelet> getKameletsByName(String name) {
        List<Kamelet> collect = this.kameletModels.entrySet().stream().filter(x -> ((String)x.getKey()).contains(name)).map(Map.Entry::getValue).collect(Collectors.toList());
        return collect;
    }

    public List<Kamelet> getKameletsByType(String type) {
        List<Kamelet> collect = this.kameletModels.entrySet().stream().filter(x -> ((String)((Kamelet)x.getValue()).getMetadata().getLabels().get("camel.apache.org/kamelet.type")).contains(type)).map(Map.Entry::getValue).collect(Collectors.toList());
        return collect;
    }

    public List<Kamelet> getKameletsByGroups(String group) {
        List<Kamelet> collect = this.kameletModels.entrySet().stream().filter(x -> ((String)((Kamelet)x.getValue()).getMetadata().getAnnotations().get("camel.apache.org/kamelet.group")).contains(group)).map(Map.Entry::getValue).collect(Collectors.toList());
        return collect;
    }

    public JSONSchemaProps getKameletDefinition(String name) {
        Kamelet kamelet = this.kameletModels.get(name);
        if (kamelet != null) {
            return kamelet.getSpec().getDefinition();
        }
        return null;
    }

    public List<Kamelet> getKameletByProvider(String provider) {
        List<Kamelet> collect = this.kameletModels.entrySet().stream().filter(x -> ((String)((Kamelet)x.getValue()).getMetadata().getAnnotations().get("camel.apache.org/provider")).equalsIgnoreCase(provider)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            return collect;
        }
        return Collections.emptyList();
    }

    public List<String> getKameletRequiredProperties(String name) {
        Kamelet kamelet = this.kameletModels.get(name);
        if (kamelet != null) {
            return kamelet.getSpec().getDefinition().getRequired();
        }
        return null;
    }

    public List<String> getKameletDependencies(String name) {
        Kamelet kamelet = this.kameletModels.get(name);
        if (kamelet != null) {
            return kamelet.getSpec().getDependencies();
        }
        return null;
    }

    public void getAllKameletDependencies() {
        TreeMap<String, Kamelet> treeMap = new TreeMap<String, Kamelet>(this.kameletModels);
        for (Map.Entry entry : treeMap.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (String dep : ((Kamelet)entry.getValue()).getSpec().getDependencies()) {
                builder.append(dep + System.lineSeparator());
            }
            System.out.println((String)entry.getKey());
            System.out.println("---------------------------------------------------------------------------------------------------");
            System.out.println(builder.toString());
            builder.append(System.lineSeparator());
        }
    }

    public JsonNode getKameletFlow(String name) {
        Kamelet kamelet = this.kameletModels.get(name);
        if (kamelet != null) {
            return kamelet.getSpec().getFlow();
        }
        return null;
    }
}

