/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.rabbitmq.source;

import java.util.concurrent.ExecutionException;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.test.CamelSourceTestSupport;
import org.apache.camel.kafkaconnector.common.test.TestMessageConsumer;
import org.apache.camel.kafkaconnector.rabbitmq.clients.RabbitMQClient;
import org.apache.camel.kafkaconnector.rabbitmq.source.CamelRabbitMQPropertyFactory;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQService;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQServiceFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Until https://github.com/apache/camel-kamelets/pull/502 is merged and published")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class RabbitMQSourceITCase
extends CamelSourceTestSupport {
    @RegisterExtension
    public static RabbitMQService rabbitmqService = RabbitMQServiceFactory.createService();
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQSourceITCase.class);
    private static final String DEFAULT_RABBITMQ_QUEUE = "Q.test.kafka.import";
    private RabbitMQClient rabbitMQClient;
    private String topicName;
    private final int expect = 10;

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-rabbitmq-source-kafka-connector"};
    }

    @BeforeEach
    public void setUp() {
        this.topicName = this.getTopicForTest((Object)this);
        this.rabbitMQClient = new RabbitMQClient(rabbitmqService.getAmqpUrl());
        this.rabbitMQClient.createQueue(DEFAULT_RABBITMQ_QUEUE);
    }

    protected void produceTestData() {
        for (int i = 0; i < 10; ++i) {
            this.rabbitMQClient.send(DEFAULT_RABBITMQ_QUEUE, "Test string message");
        }
    }

    protected void verifyMessages(TestMessageConsumer<?> consumer) {
        int received = consumer.consumedMessages().size();
        Assertions.assertEquals((int)received, (int)10, (String)"Didn't process the expected amount of messages");
    }

    @Test
    @Timeout(value=90L)
    public void testSource() throws ExecutionException, InterruptedException {
        CamelRabbitMQPropertyFactory factory = ((CamelRabbitMQPropertyFactory)CamelRabbitMQPropertyFactory.basic().withKafkaTopic(this.topicName)).withAddresses(rabbitmqService.connectionProperties().hostname() + ":" + rabbitmqService.connectionProperties().port()).withPassword(rabbitmqService.connectionProperties().password()).withUsername(rabbitmqService.connectionProperties().username()).withExchangeName("default");
        this.runTest((ConnectorPropertyFactory)factory, this.topicName, 10);
    }
}

