/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.rabbitmq.sink;

import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Delivery;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;
import org.apache.camel.kafkaconnector.common.test.CamelSinkTestSupport;
import org.apache.camel.kafkaconnector.rabbitmq.clients.RabbitMQClient;
import org.apache.camel.kafkaconnector.rabbitmq.sink.CamelRabbitMQPropertyFactory;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQService;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQServiceFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Until we have a rabbitmq sink kamelet see: https://github.com/apache/camel-kamelets/issues/45")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class RabbitMQSinkITCase
extends CamelSinkTestSupport {
    @RegisterExtension
    public static RabbitMQService rabbitmqService = RabbitMQServiceFactory.createService();
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQSinkITCase.class);
    private static final String DEFAULT_RABBITMQ_QUEUE = "Q.test.kafka.import";
    private String topicName;
    private RabbitMQClient rabbitMQClient;
    private int received;
    private final int expect = 10;

    protected String[] getConnectorsInTest() {
        return new String[]{"camel-rabbitmq-sink-kafka-connector"};
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.topicName = this.getTopicForTest((Object)this);
        this.received = 0;
        this.rabbitMQClient = new RabbitMQClient(rabbitmqService.getAmqpUrl());
        this.rabbitMQClient.createQueue(DEFAULT_RABBITMQ_QUEUE);
        this.rabbitMQClient.start();
    }

    @AfterEach
    public void tearDown() {
        this.rabbitMQClient.stop();
    }

    protected void consumeMessages(CountDownLatch latch) {
        DeliverCallback deliveryCallback = (consumerTag, delivery) -> {
            if (!this.checkRecord(delivery)) {
                latch.countDown();
            }
        };
        try {
            this.rabbitMQClient.receive(DEFAULT_RABBITMQ_QUEUE, deliveryCallback);
        }
        catch (Exception e) {
            LOG.error("RabbitMQ test failed: {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)e.getMessage());
        }
    }

    protected void verifyMessages(CountDownLatch latch) throws InterruptedException {
        if (latch.await(15L, TimeUnit.SECONDS)) {
            Assertions.assertEquals((int)this.received, (int)10, (String)("Didn't process the expected amount of messages: " + this.received + " != " + 10));
        } else {
            Assertions.fail((String)"Failed to receive the messages within the specified time");
        }
    }

    private boolean checkRecord(Delivery rabbitMQDelivery) {
        String message = new String(rabbitMQDelivery.getBody(), StandardCharsets.UTF_8);
        LOG.debug("Received: {}", (Object)message);
        ++this.received;
        return this.received != 10;
    }

    @Test
    @Timeout(value=90L)
    public void testSource() throws Exception {
        CamelRabbitMQPropertyFactory factory = ((CamelRabbitMQPropertyFactory)CamelRabbitMQPropertyFactory.basic().withTopics(this.topicName)).withUsername(rabbitmqService.connectionProperties().username()).withPassword(rabbitmqService.connectionProperties().password()).withAutoDelete(false).withQueue(DEFAULT_RABBITMQ_QUEUE).withRoutingKey(DEFAULT_RABBITMQ_QUEUE).withSkipExchangeDeclare(true).withSkipQueueBind(true).withHostname(rabbitmqService.connectionProperties().hostname()).withPortNumber(rabbitmqService.connectionProperties().port());
        this.runTest((ConnectorPropertyFactory)factory, this.topicName, 10);
    }
}

