/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.rabbitmq.clients;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.MessageProperties;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQClient {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQClient.class);
    private static final String DEFAULT_EXCHANGE_TYPE = "direct";
    private Connection connection;
    private Channel channel;
    private ConnectionFactory factory = new ConnectionFactory();

    public RabbitMQClient(String uri) {
        try {
            this.factory.setUri(uri);
        }
        catch (Exception e) {
            LOG.error("Unable to create the RabbitMQ client {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((Throwable)e);
        }
    }

    private static void capturingClose(Closeable closeable, String closableDescription) {
        LOG.debug("Closing the " + closableDescription);
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing the {}: {}", new Object[]{closableDescription, t.getMessage(), t});
            }
        }
    }

    private static void capturingClose(AutoCloseable closeable, String closableDescription) {
        LOG.debug("Closing the " + closableDescription);
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing the {}: {}", new Object[]{closableDescription, t.getMessage(), t});
            }
        }
    }

    public void start() throws Exception {
        LOG.debug("Starting the RabbitMQ client");
        try {
            LOG.debug("Creating the connection");
            this.connection = this.factory.newConnection();
            LOG.debug("Connection created successfully");
            LOG.debug("Creating the Channel");
            this.channel = this.connection.createChannel();
            LOG.debug("Channel created successfully");
        }
        catch (Throwable t) {
            LOG.trace("Something wrong happened while initializing the RabbitMQ client: {}", (Object)t.getMessage(), (Object)t);
            RabbitMQClient.capturingClose((Closeable)this.connection, "connection");
            throw t;
        }
    }

    public void stop() {
        try {
            LOG.debug("Stopping the channel");
            RabbitMQClient.capturingClose((AutoCloseable)this.channel, "channel");
            LOG.debug("Stopping the RabbitMQ connection");
            RabbitMQClient.capturingClose((Closeable)this.connection, "connection");
        }
        finally {
            this.channel = null;
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQP.Queue.DeclareOk createQueue(String queueName) {
        try {
            this.start();
            AMQP.Queue.DeclareOk declareOk = this.channel.queueDeclare(queueName, true, false, false, null);
            return declareOk;
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            AMQP.Queue.DeclareOk declareOk = null;
            return declareOk;
        }
        finally {
            this.stop();
        }
    }

    public AMQP.Exchange.DeclareOk createExchange(String exchangeName) {
        return this.createExchange(exchangeName, DEFAULT_EXCHANGE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQP.Exchange.DeclareOk createExchange(String exchangeName, String exchangeType) {
        try {
            this.start();
            AMQP.Exchange.DeclareOk declareOk = this.channel.exchangeDeclare(exchangeName, exchangeType);
            return declareOk;
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            AMQP.Exchange.DeclareOk declareOk = null;
            return declareOk;
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQP.Queue.BindOk bindExchangeToQueue(String exchangeName, String queueName) {
        try {
            this.start();
            AMQP.Queue.BindOk bindOk = this.channel.queueBind(exchangeName, exchangeName, "");
            return bindOk;
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            AMQP.Queue.BindOk bindOk = null;
            return bindOk;
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String queue, String data) {
        try {
            this.start();
            this.channel.basicPublish("", queue, MessageProperties.PERSISTENT_TEXT_PLAIN, data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            this.stop();
        }
    }

    public void receive(String queue, DeliverCallback deliverCallback) throws Exception {
        this.channel.basicConsume(queue, true, deliverCallback, consumerTag -> {});
    }
}

