/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);
    private static Properties properties = new Properties();

    private PropertyUtils() {
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void load() {
        String fileName = System.getProperty("test.properties");
        if (fileName == null) {
            LOG.info("Test properties was not provided, therefore not loading any test properties");
            return;
        }
        try (FileInputStream stream = new FileInputStream(fileName);){
            properties.load(stream);
            System.getProperties().putAll((Map<?, ?>)properties);
        }
        catch (FileNotFoundException e) {
            LOG.error("Test properties provided at {} does not exist, therefore aborting the test execution", (Object)fileName);
            Assert.fail((String)"The given test properties file does not exist");
        }
        catch (IOException e) {
            LOG.error("I/O error reading the test properties at {}: {}", new Object[]{fileName, e.getMessage(), e});
            Assert.fail((String)"Unable to read the test properties file");
        }
    }
}

