/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.utils;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public final class NetworkUtils {
    public static final int DEFAULT_STARTING_PORT = 49152;
    public static final int DEFAULT_ENDING_PORT = 65535;

    private NetworkUtils() {
    }

    public static int getFreePort() {
        return NetworkUtils.getFreePort("localhost");
    }

    public static int getFreePort(String host) {
        return NetworkUtils.getFreePort(host, 49152, 65535);
    }

    public static int getFreePort(String host, Protocol protocol) {
        return NetworkUtils.getFreePort(host, 49152, 65535, protocol);
    }

    public static int getFreePort(String host, int startingPort, int endingPort) {
        return NetworkUtils.getFreePort(host, startingPort, endingPort, Protocol.TCP);
    }

    public static int getFreePort(String host, int startingPort, int endingPort, Protocol protocol) {
        int freePort = 0;
        for (int i = startingPort; i <= endingPort; ++i) {
            boolean found = NetworkUtils.checkPort(host, i, protocol);
            if (!found) continue;
            freePort = i;
            break;
        }
        return freePort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkPort(String host, int port, Protocol protocol) {
        try {
            switch (protocol) {
                case TCP: {
                    try (ServerSocket ss = new ServerSocket();){
                        ss.setReuseAddress(true);
                        ss.bind(new InetSocketAddress(host, port), 1);
                        ss.getLocalPort();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                case UDP: {
                    new DatagramSocket(new InetSocketAddress(host, port)).close();
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static enum Protocol {
        UDP,
        TCP;

    }
}

