/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafka;

import com.github.dockerjava.api.command.CreateContainerCmd;
import java.util.function.Consumer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    private static final String ZOOKEEPER_CONTAINER = System.getProperty("itest.zookeeper.container.image");
    private static final int ZOOKEEPER_PORT = 2181;

    public ZookeeperContainer(Network network, final String name) {
        super(ZOOKEEPER_CONTAINER);
        this.withEnv("LOG_DIR", "/tmp/logs");
        this.withExposedPorts(new Integer[]{2181});
        this.withNetwork(network);
        this.withCreateContainerCmdModifier(new Consumer<CreateContainerCmd>(){

            @Override
            public void accept(CreateContainerCmd createContainerCmd) {
                createContainerCmd.withHostName(name);
                createContainerCmd.withName(name);
            }
        });
        this.withCommand(new String[]{"sh", "-c", "bin/zookeeper-server-start.sh config/zookeeper.properties"});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public int getZookeeperPort() {
        return this.getMappedPort(2181);
    }
}

