/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common.services.kafka;

import org.apache.camel.kafkaconnector.common.services.kafka.ContainerLocalKafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.EmbeddedKafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.KafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.RemoteKafkaService;
import org.apache.camel.kafkaconnector.common.services.kafka.StrimziService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaServiceFactory.class);

    private KafkaServiceFactory() {
    }

    public static KafkaService createService() {
        String kafkaInstanceType = System.getProperty("kafka.instance.type");
        if (kafkaInstanceType == null || kafkaInstanceType.equals("embedded")) {
            return new EmbeddedKafkaService();
        }
        if (kafkaInstanceType.equals("local-strimzi-container")) {
            return new StrimziService();
        }
        if (kafkaInstanceType.equals("local-kafka-container")) {
            return new ContainerLocalKafkaService();
        }
        if (kafkaInstanceType.equals("remote")) {
            return new RemoteKafkaService();
        }
        LOG.error("Kafka instance must be one of 'local-strimzi-container', 'local-kafka-container', 'embedded' or 'remote");
        throw new UnsupportedOperationException("Invalid Kafka instance type:");
    }
}

