/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.common;

import java.util.function.Function;
import org.apache.camel.kafkaconnector.common.ConnectorPropertyFactory;

public class EndpointUrlBuilder<T extends ConnectorPropertyFactory> {
    private final Function<String, T> setter;
    private String baseUrl;
    private boolean started;

    public EndpointUrlBuilder(Function<String, T> setter, String baseUrl) {
        this.setter = setter;
        this.baseUrl = baseUrl;
    }

    private EndpointUrlBuilder<T> start() {
        if (this.started) {
            throw new RuntimeException("Already started preparing the URL for formatting");
        }
        this.started = true;
        return this;
    }

    public EndpointUrlBuilder<T> append(String name, String value) {
        if (!this.started) {
            this.start();
            this.baseUrl = String.format("%s?%s=%s", this.baseUrl, name, value);
        } else {
            this.baseUrl = String.format("%s&%s=%s", this.baseUrl, name, value);
        }
        return this;
    }

    public EndpointUrlBuilder<T> appendIfAvailable(String name, String value) {
        if (value != null && !value.isEmpty()) {
            return this.append(name, value);
        }
        return this;
    }

    public EndpointUrlBuilder<T> append(String name, int value) {
        if (!this.started) {
            this.start();
            this.baseUrl = String.format("%s?%s=%d", this.baseUrl, name, value);
        } else {
            this.baseUrl = String.format("%s&%s=%d", this.baseUrl, name, value);
        }
        return this;
    }

    public T buildUrl() {
        return (T)((ConnectorPropertyFactory)this.setter.apply(this.baseUrl));
    }
}

