/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    private static final int DEFAULT_INET_ADDRESS_COUNT = 1;

    public static EventLoopGroup newNioOrEpollEventLoopGroup() {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup();
        }
        return new NioEventLoopGroup();
    }

    public static EventLoopGroup newNioOrEpollEventLoopGroup(int nThreads) {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(nThreads);
        }
        return new NioEventLoopGroup(nThreads);
    }

    public static Class<? extends SocketChannel> nioOrEpollSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> nioOrEpollServerSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static int getClientReachableLocalInetAddressCount() {
        try {
            HashSet<InetAddress> validInetAddresses = new HashSet<InetAddress>();
            Enumeration<NetworkInterface> allNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(allNetworkInterfaces)) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress.isLinkLocalAddress()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring link-local InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isMulticastAddress()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring multicast InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isLoopbackAddress()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring loopback InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    validInetAddresses.add(inetAddress);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected {} local network addresses", (Object)validInetAddresses.size());
                LOG.debug("Resolved local addresses are: {}", (Object)Arrays.toString(validInetAddresses.toArray()));
            }
            return validInetAddresses.size() > 0 ? validInetAddresses.size() : 1;
        }
        catch (SocketException ex) {
            LOG.warn("Failed to list all network interfaces, assuming 1", (Throwable)ex);
            return 1;
        }
    }
}

