/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group.internal;

import org.apache.camel.component.zookeepermaster.group.internal.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeOperation
implements Operation {
    public static final Logger LOG = LoggerFactory.getLogger(CompositeOperation.class);
    private Operation[] operations;

    public CompositeOperation(Operation ... operations) {
        this.operations = operations;
    }

    @Override
    public void invoke() throws Exception {
        for (Operation op : this.operations) {
            try {
                op.invoke();
                if (!Thread.currentThread().isInterrupted()) continue;
                LOG.debug("Interrupting composite operation");
                Thread.currentThread().interrupt();
                break;
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupting composite operation");
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

