/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import java.util.HashMap;
import java.util.Map;
import org.scribe.model.Request;
import org.scribe.model.Verb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthRequest
extends Request {
    private static final String OAUTH_PREFIX = "oauth_";
    private Map<String, String> oauthParameters = new HashMap<String, String>();
    private String realm;

    public OAuthRequest(Verb verb, String url) {
        super(verb, url);
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    private String checkKey(String key) {
        if (key.startsWith(OAUTH_PREFIX) || key.equals("scope")) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s' or start with '%s'", "scope", OAUTH_PREFIX));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public String toString() {
        return String.format("@OAuthRequest(%s, %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

