/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5Client {
    private static final Logger LOGGER = Logger.getLogger(Socks5Client.class.getName());
    protected Bytestream.StreamHost streamHost;
    protected String digest;

    public Socks5Client(Bytestream.StreamHost streamHost, String digest) {
        this.streamHost = streamHost;
        this.digest = digest;
    }

    public Socket getSocket(int timeout) throws IOException, InterruptedException, TimeoutException, SmackException, XMPPException {
        FutureTask<Socket> futureTask = new FutureTask<Socket>(new Callable<Socket>(){

            @Override
            public Socket call() throws IOException, SmackException {
                Socket socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress(Socks5Client.this.streamHost.getAddress(), Socks5Client.this.streamHost.getPort());
                socket.connect(socketAddress);
                try {
                    Socks5Client.this.establish(socket);
                }
                catch (SmackException e) {
                    if (!socket.isClosed()) {
                        try {
                            socket.close();
                        }
                        catch (IOException e2) {
                            LOGGER.log(Level.WARNING, "Could not close SOCKS5 socket", e2);
                        }
                    }
                    throw e;
                }
                return socket;
            }
        });
        Thread executor = new Thread(futureTask);
        executor.start();
        try {
            return futureTask.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SmackException) {
                    throw (SmackException)cause;
                }
            }
            throw new SmackException("Error while connecting to SOCKS5 proxy", (Throwable)e);
        }
    }

    protected void establish(Socket socket) throws SmackException, IOException {
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        byte[] cmd = new byte[]{5, 1, 0};
        out.write(cmd);
        out.flush();
        byte[] response = new byte[2];
        in.readFully(response);
        if (response[0] != 5 || response[1] != 0) {
            throw new SmackException("Remote SOCKS5 server responded with unexpected version: " + response[0] + ' ' + response[1] + ". Should be 0x05 0x00.");
        }
        byte[] connectionRequest = this.createSocks5ConnectRequest();
        out.write(connectionRequest);
        out.flush();
        byte[] connectionResponse = Socks5Utils.receiveSocks5Message(in);
        connectionRequest[1] = 0;
        if (!Arrays.equals(connectionRequest, connectionResponse)) {
            throw new SmackException("Connection request does not equal connection response. Response: " + Arrays.toString(connectionResponse) + ". Request: " + Arrays.toString(connectionRequest));
        }
    }

    private byte[] createSocks5ConnectRequest() {
        byte[] addr;
        try {
            addr = this.digest.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        byte[] data = new byte[7 + addr.length];
        data[0] = 5;
        data[1] = 1;
        data[2] = 0;
        data[3] = 3;
        data[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data, 5, addr.length);
        data[data.length - 2] = 0;
        data[data.length - 1] = 0;
        return data;
    }
}

