/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MUCParserUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static MUCItem parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        MUCAffiliation affiliation = MUCAffiliation.fromString(parser.getAttributeValue("", "affiliation"));
        Resourcepart nick = ParserUtils.getResourcepartAttribute((XmlPullParser)parser, (String)"nick");
        MUCRole role = MUCRole.fromString(parser.getAttributeValue("", "role"));
        Jid jid = ParserUtils.getJidAttribute((XmlPullParser)parser);
        Jid actor = null;
        Resourcepart actorNick = null;
        String reason = null;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "actor": {
                            actor = ParserUtils.getJidAttribute((XmlPullParser)parser);
                            String actorNickString = parser.getAttributeValue("", "nick");
                            if (actorNickString != null) {
                                actorNick = Resourcepart.from((String)actorNickString);
                                break;
                            }
                            break block0;
                        }
                        case "reason": {
                            reason = parser.nextText();
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new MUCItem(affiliation, role, actor, reason, jid, nick, actorNick);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Destroy parseDestroy(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        EntityBareJid jid = ParserUtils.getBareJidAttribute((XmlPullParser)parser);
        String reason = null;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "reason": {
                            reason = parser.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (initialDepth != parser.getDepth()) break;
                    return new Destroy(jid, reason);
                }
            }
        }
    }
}

