/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jxmpp.jid.FullJid;

public final class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ACTION_ATTRIBUTE_NAME = "action";
    public static final String INITIATOR_ATTRIBUTE_NAME = "initiator";
    public static final String RESPONDER_ATTRIBUTE_NAME = "responder";
    public static final String SESSION_ID_ATTRIBUTE_NAME = "sid";
    public static final String ELEMENT = "jingle";
    private final String sessionId;
    private final JingleAction action;
    private final FullJid initiator;
    private final FullJid responder;
    private final JingleReason reason;
    private final List<JingleContent> contents;

    private Jingle(String sessionId, JingleAction action, FullJid initiator, FullJid responder, JingleReason reason, List<JingleContent> contents) {
        super(ELEMENT, NAMESPACE);
        this.sessionId = (String)StringUtils.requireNotNullOrEmpty((CharSequence)sessionId, (String)"Jingle session ID must not be null");
        this.action = (JingleAction)((Object)Objects.requireNonNull((Object)((Object)action), (String)"Jingle action must not be null"));
        this.initiator = initiator;
        this.responder = responder;
        this.reason = reason;
        this.contents = contents != null ? Collections.unmodifiableList(contents) : Collections.emptyList();
        this.setType(IQ.Type.set);
    }

    public FullJid getInitiator() {
        return this.initiator;
    }

    public FullJid getResponder() {
        return this.responder;
    }

    public String getSid() {
        return this.sessionId;
    }

    public JingleAction getAction() {
        return this.action;
    }

    public JingleReason getReason() {
        return this.reason;
    }

    public List<JingleContent> getContents() {
        return this.contents;
    }

    public JingleContent getSoleContentOrThrow() {
        if (this.contents.isEmpty()) {
            return null;
        }
        if (this.contents.size() > 1) {
            throw new IllegalStateException();
        }
        return this.contents.get(0);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute(INITIATOR_ATTRIBUTE_NAME, (CharSequence)this.getInitiator());
        xml.optAttribute(RESPONDER_ATTRIBUTE_NAME, (CharSequence)this.getResponder());
        xml.optAttribute(ACTION_ATTRIBUTE_NAME, (Enum)this.getAction());
        xml.optAttribute(SESSION_ID_ATTRIBUTE_NAME, this.getSid());
        xml.rightAngleBracket();
        xml.optElement((Element)this.reason);
        xml.append(this.contents);
        return xml;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String sid;
        private JingleAction action;
        private FullJid initiator;
        private FullJid responder;
        private JingleReason reason;
        private List<JingleContent> contents;

        private Builder() {
        }

        public Builder setSessionId(String sessionId) {
            StringUtils.requireNotNullOrEmpty((CharSequence)sessionId, (String)"Session ID must not be null or empty");
            this.sid = sessionId;
            return this;
        }

        public Builder setAction(JingleAction action) {
            this.action = action;
            return this;
        }

        public Builder setInitiator(FullJid initator) {
            this.initiator = initator;
            return this;
        }

        public Builder setResponder(FullJid responder) {
            this.responder = responder;
            return this;
        }

        public Builder addJingleContent(JingleContent content) {
            if (this.contents == null) {
                this.contents = new ArrayList<JingleContent>(1);
            }
            this.contents.add(content);
            return this;
        }

        public Builder setReason(JingleReason.Reason reason) {
            this.reason = new JingleReason(reason);
            return this;
        }

        public Builder setReason(JingleReason reason) {
            this.reason = reason;
            return this;
        }

        public Jingle build() {
            return new Jingle(this.sid, this.action, this.initiator, this.responder, this.reason, this.contents);
        }
    }
}

