/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.minidns.record.Data;
import org.minidns.record.Record;
import org.minidns.util.Base64;

public class OPENPGPKEY
extends Data {
    private final byte[] publicKeyPacket;
    private String publicKeyPacketBase64Cache;

    public static OPENPGPKEY parse(DataInputStream dis, int length) throws IOException {
        byte[] publicKeyPacket = new byte[length];
        dis.readFully(publicKeyPacket);
        return new OPENPGPKEY(publicKeyPacket);
    }

    OPENPGPKEY(byte[] publicKeyPacket) {
        this.publicKeyPacket = publicKeyPacket;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.OPENPGPKEY;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.publicKeyPacket);
    }

    public String toString() {
        return this.getPublicKeyPacketBase64();
    }

    public String getPublicKeyPacketBase64() {
        if (this.publicKeyPacketBase64Cache == null) {
            this.publicKeyPacketBase64Cache = Base64.encodeToString(this.publicKeyPacket);
        }
        return this.publicKeyPacketBase64Cache;
    }

    public byte[] getPublicKeyPacket() {
        return (byte[])this.publicKeyPacket.clone();
    }
}

