/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MultipleIoException
extends IOException {
    private static final long serialVersionUID = -5932211337552319515L;
    private final List<IOException> ioExceptions;

    private MultipleIoException(List<? extends IOException> ioExceptions) {
        super(MultipleIoException.getMessage(ioExceptions));
        assert (!ioExceptions.isEmpty());
        this.ioExceptions = Collections.unmodifiableList(ioExceptions);
    }

    public List<IOException> getExceptions() {
        return this.ioExceptions;
    }

    private static String getMessage(Collection<? extends Exception> exceptions) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends Exception> it = exceptions.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getMessage());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static void throwIfRequired(List<? extends IOException> ioExceptions) throws IOException {
        if (ioExceptions == null || ioExceptions.isEmpty()) {
            return;
        }
        if (ioExceptions.size() == 1) {
            throw ioExceptions.get(0);
        }
        throw new MultipleIoException(ioExceptions);
    }

    public static IOException toIOException(List<? extends IOException> ioExceptions) {
        int size = ioExceptions.size();
        if (size == 1) {
            return ioExceptions.get(0);
        }
        if (size > 1) {
            return new MultipleIoException(ioExceptions);
        }
        return null;
    }
}

