/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.AbstractDebugger;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;

public class ConsoleDebugger
extends AbstractDebugger {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss");

    public ConsoleDebugger(XMPPConnection connection) {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(String logMessage) {
        String formatedDate;
        SimpleDateFormat simpleDateFormat = this.dateFormatter;
        synchronized (simpleDateFormat) {
            formatedDate = this.dateFormatter.format(new Date());
        }
        System.out.println(formatedDate + ' ' + logMessage);
    }

    @Override
    protected void log(String logMessage, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        this.log(logMessage + sw);
    }

    public static final class Factory
    implements SmackDebuggerFactory {
        public static final SmackDebuggerFactory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public SmackDebugger create(XMPPConnection connection) throws IllegalArgumentException {
            return new ConsoleDebugger(connection);
        }
    }
}

