/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class NSEC
extends Data {
    private static final Logger LOGGER = Logger.getLogger(NSEC.class.getName());
    public final DnsName next;
    private final byte[] typeBitmap;
    public final Record.TYPE[] types;

    public static NSEC parse(DataInputStream dis, byte[] data, int length) throws IOException {
        DnsName next = DnsName.parse(dis, data);
        byte[] typeBitmap = new byte[length - next.size()];
        if (dis.read(typeBitmap) != typeBitmap.length) {
            throw new IOException();
        }
        Record.TYPE[] types = NSEC.readTypeBitMap(typeBitmap);
        return new NSEC(next, types);
    }

    public NSEC(String next, Record.TYPE[] types) {
        this(DnsName.from(next), types);
    }

    public NSEC(DnsName next, Record.TYPE[] types) {
        this.next = next;
        this.types = types;
        this.typeBitmap = NSEC.createTypeBitMap(types);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.NSEC;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        this.next.writeToStream(dos);
        dos.write(this.typeBitmap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.next).append('.');
        for (Record.TYPE type : this.types) {
            sb.append(' ').append((Object)type);
        }
        return sb.toString();
    }

    static byte[] createTypeBitMap(Record.TYPE[] types) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        for (Record.TYPE type : types) {
            typeList.add(type.getValue());
        }
        Collections.sort(typeList);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            int windowBlock = -1;
            byte[] bitmap = null;
            for (Integer type : typeList) {
                if (windowBlock == -1 || type >> 8 != windowBlock) {
                    if (windowBlock != -1) {
                        NSEC.writeOutBlock(bitmap, dos);
                    }
                    windowBlock = type >> 8;
                    dos.writeByte(windowBlock);
                    bitmap = new byte[32];
                }
                int a = (type >> 3) % 32;
                int b = type % 8;
                int n = a;
                bitmap[n] = (byte)(bitmap[n] | 128 >> b);
            }
            if (windowBlock != -1) {
                NSEC.writeOutBlock(bitmap, dos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private static void writeOutBlock(byte[] values, DataOutputStream dos) throws IOException {
        int i;
        int n = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            n = i + 1;
        }
        dos.writeByte(n);
        for (i = 0; i < n; ++i) {
            dos.writeByte(values[i]);
        }
    }

    static Record.TYPE[] readTypeBitMap(byte[] typeBitmap) throws IOException {
        int bitmapLength;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(typeBitmap));
        ArrayList<Record.TYPE> typeList = new ArrayList<Record.TYPE>();
        for (int read = 0; typeBitmap.length > read; read += bitmapLength + 2) {
            int windowBlock = dis.readUnsignedByte();
            bitmapLength = dis.readUnsignedByte();
            for (int i = 0; i < bitmapLength; ++i) {
                int b = dis.readUnsignedByte();
                for (int j = 0; j < 8; ++j) {
                    if ((b >> j & 1) <= 0) continue;
                    int typeInt = (windowBlock << 8) + i * 8 + (7 - j);
                    Record.TYPE type = Record.TYPE.getType(typeInt);
                    if (type == Record.TYPE.UNKNOWN) {
                        LOGGER.warning("Skipping unknown type in type bitmap: " + typeInt);
                        continue;
                    }
                    typeList.add(type);
                }
            }
        }
        return typeList.toArray(new Record.TYPE[typeList.size()]);
    }
}

