/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class XmlSignerEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "xmlsecurity-sign".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "name", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(29);
        props.add("canonicalizationMethod");
        props.add("omitXmlDeclaration");
        props.add("clearHeaders");
        props.add("synchronous");
        props.add("outputXmlEncoding");
        props.add("contentObjectId");
        props.add("parentNamespace");
        props.add("signatureId");
        props.add("transformMethods");
        props.add("parentXpath");
        props.add("xpathsToIdAttributes");
        props.add("parentLocalName");
        props.add("contentReferenceType");
        props.add("uriDereferencer");
        props.add("keyAccessor");
        props.add("prefixForXmlSignatureNamespace");
        props.add("plainText");
        props.add("plainTextEncoding");
        props.add("addKeyInfoReference");
        props.add("digestAlgorithm");
        props.add("schemaResourceUri");
        props.add("signatureAlgorithm");
        props.add("lazyStartProducer");
        props.add("contentReferenceUri");
        props.add("disallowDoctypeDecl");
        props.add("baseUri");
        props.add("name");
        props.add("cryptoContextProperties");
        props.add("properties");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

