/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.XAdESEncapsulatedPKIData;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XAdESSignatureProperties
implements XmlSignatureProperties {
    public static final String HTTP_URI_ETSI_ORG_01903_V1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String HTTP_URI_ETSI_ORG_01903_V1_1_1 = "http://uri.etsi.org/01903/v1.1.1#";
    public static final String HTTP_URI_ETSI_ORG_01903_V1_2_2 = "http://uri.etsi.org/01903/v1.2.2#";
    public static final String SIG_POLICY_NONE = "None";
    public static final String SIG_POLICY_IMPLIED = "Implied";
    public static final String SIG_POLICY_EXPLICIT_ID = "ExplicitId";
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureProperties.class);
    private static final Set<String> SIG_POLICY_VALUES = new TreeSet<String>();
    private boolean addSigningTime = true;
    private String namespace = "http://uri.etsi.org/01903/v1.3.2#";
    private String prefix = "etsi";
    private List<String> signingCertificateURIs = Collections.emptyList();
    private String digestAlgorithmForSigningCertificate = "http://www.w3.org/2001/04/xmlenc#sha256";
    private String signaturePolicy = "None";
    private String sigPolicyId;
    private String sigPolicyIdQualifier;
    private String sigPolicyIdDescription;
    private List<String> sigPolicyIdDocumentationReferences = Collections.emptyList();
    private String signaturePolicyDigestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    private String signaturePolicyDigestValue;
    private List<String> sigPolicyQualifiers = Collections.emptyList();
    private String dataObjectFormatDescription;
    private String dataObjectFormatMimeType;
    private String dataObjectFormatIdentifier;
    private String dataObjectFormatIdentifierQualifier;
    private String dataObjectFormatIdentifierDescription;
    private List<String> dataObjectFormatIdentifierDocumentationReferences = Collections.emptyList();
    private List<String> signerClaimedRoles = Collections.emptyList();
    private List<XAdESEncapsulatedPKIData> signerCertifiedRoles = Collections.emptyList();
    private String signatureProductionPlaceCity;
    private String signatureProductionPlaceStateOrProvince;
    private String signatureProductionPlacePostalCode;
    private String signatureProductionPlaceCountryName;
    private String commitmentTypeId;
    private String commitmentTypeIdQualifier;
    private String commitmentTypeIdDescription;
    private List<String> commitmentTypeIdDocumentationReferences = Collections.emptyList();
    private List<String> commitmentTypeQualifiers = Collections.emptyList();

    public boolean isAddSigningTime() {
        return this.addSigningTime;
    }

    public void setAddSigningTime(boolean addSigningTime) {
        this.addSigningTime = addSigningTime;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Parameter 'namespace' is null");
        }
        this.namespace = namespace;
    }

    protected String findNamespace(Message message) {
        return (String)message.getHeader("CamelXmlSignatureXAdESNamespace", (Object)this.getNamespace(), String.class);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected String findPrefix(Message message) {
        return (String)message.getHeader("CamelXmlSignatureXAdESPrefix", (Object)this.getPrefix(), String.class);
    }

    public void setSigningCertificateURIs(List<String> signingCertificateURIs) {
        if (signingCertificateURIs == null) {
            throw new IllegalArgumentException("Parameter 'signingCertificateURIs' is null");
        }
        this.signingCertificateURIs = new ArrayList<String>(signingCertificateURIs);
    }

    public List<String> getSigningCertificateURIs() {
        return this.signingCertificateURIs;
    }

    public String getDigestAlgorithmForSigningCertificate() {
        return this.digestAlgorithmForSigningCertificate;
    }

    public void setDigestAlgorithmForSigningCertificate(String digestAlgorithm) {
        this.digestAlgorithmForSigningCertificate = digestAlgorithm;
    }

    public String getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(String signaturePolicy) {
        if (!SIG_POLICY_VALUES.contains(signaturePolicy)) {
            throw new IllegalArgumentException(String.format("Signature policy '%s' is invalid. Possible values are 'None', 'Implied', and 'ExplicitId'.", signaturePolicy));
        }
        this.signaturePolicy = signaturePolicy;
    }

    public String getSigPolicyId() {
        return this.sigPolicyId;
    }

    public void setSigPolicyId(String sigPolicyId) {
        this.sigPolicyId = sigPolicyId;
    }

    public String getSigPolicyIdQualifier() {
        return this.sigPolicyIdQualifier;
    }

    public void setSigPolicyIdQualifier(String sigPolicyIdQualifier) {
        this.sigPolicyIdQualifier = sigPolicyIdQualifier;
    }

    public String getSigPolicyIdDescription() {
        return this.sigPolicyIdDescription;
    }

    public void setSigPolicyIdDescription(String sigPolicyIdDescription) {
        this.sigPolicyIdDescription = sigPolicyIdDescription;
    }

    public List<String> getSigPolicyIdDocumentationReferences() {
        return this.sigPolicyIdDocumentationReferences;
    }

    public void setSigPolicyIdDocumentationReferences(List<String> sigPolicyIdDocumentationReferences) {
        if (sigPolicyIdDocumentationReferences == null) {
            throw new IllegalArgumentException("Parameter 'sigPolicyIdDocumentationReferences' is null");
        }
        for (String ref : sigPolicyIdDocumentationReferences) {
            if (ref != null && !ref.isEmpty()) continue;
            throw new IllegalArgumentException("At least one documentation reference of the signature policy is null or empty");
        }
        this.sigPolicyIdDocumentationReferences = sigPolicyIdDocumentationReferences;
    }

    public String getSignaturePolicyDigestAlgorithm() {
        return this.signaturePolicyDigestAlgorithm;
    }

    public void setSignaturePolicyDigestAlgorithm(String signaturePolicyDigestAlgorithm) {
        this.signaturePolicyDigestAlgorithm = signaturePolicyDigestAlgorithm;
    }

    public String getSignaturePolicyDigestValue() {
        return this.signaturePolicyDigestValue;
    }

    public void setSignaturePolicyDigestValue(String signaturePolicyDigestValue) {
        this.signaturePolicyDigestValue = signaturePolicyDigestValue;
    }

    public List<String> getSigPolicyQualifiers() {
        return this.sigPolicyQualifiers;
    }

    public void setSigPolicyQualifiers(List<String> sigPolicyQualifiers) {
        if (sigPolicyQualifiers == null) {
            throw new IllegalArgumentException("Parameter 'sigPolicyQualifiers' is null");
        }
        for (String qualifier : sigPolicyQualifiers) {
            if (qualifier != null && !qualifier.isEmpty()) continue;
            throw new IllegalArgumentException("At least one of the policy qualifiers is null or empty");
        }
        this.sigPolicyQualifiers = new ArrayList<String>(sigPolicyQualifiers);
    }

    public String getDataObjectFormatDescription() {
        return this.dataObjectFormatDescription;
    }

    public void setDataObjectFormatDescription(String dataObjectFormatDescription) {
        this.dataObjectFormatDescription = dataObjectFormatDescription;
    }

    public String getDataObjectFormatMimeType() {
        return this.dataObjectFormatMimeType;
    }

    public void setDataObjectFormatMimeType(String dataObjectFormatMimeType) {
        this.dataObjectFormatMimeType = dataObjectFormatMimeType;
    }

    public String getDataObjectFormatIdentifier() {
        return this.dataObjectFormatIdentifier;
    }

    public void setDataObjectFormatIdentifier(String dataObjectFormatIdentifier) {
        this.dataObjectFormatIdentifier = dataObjectFormatIdentifier;
    }

    public String getDataObjectFormatIdentifierQualifier() {
        return this.dataObjectFormatIdentifierQualifier;
    }

    public void setDataObjectFormatIdentifierQualifier(String dataObjectFormatIdentifierQualifier) {
        this.dataObjectFormatIdentifierQualifier = dataObjectFormatIdentifierQualifier;
    }

    public String getDataObjectFormatIdentifierDescription() {
        return this.dataObjectFormatIdentifierDescription;
    }

    public void setDataObjectFormatIdentifierDescription(String dataObjectFormatIdentifierDescription) {
        this.dataObjectFormatIdentifierDescription = dataObjectFormatIdentifierDescription;
    }

    public List<String> getDataObjectFormatIdentifierDocumentationReferences() {
        return this.dataObjectFormatIdentifierDocumentationReferences;
    }

    public void setDataObjectFormatIdentifierDocumentationReferences(List<String> dataObjectFormatIdentifierDocumentationReferences) {
        if (dataObjectFormatIdentifierDocumentationReferences == null) {
            throw new IllegalArgumentException("Parameter 'dataObjectFormatIdentifierDocumentationReferences' is null");
        }
        for (String ref : dataObjectFormatIdentifierDocumentationReferences) {
            if (ref != null && !ref.isEmpty()) continue;
            throw new IllegalArgumentException("At least one reference of the identifier of the data object format is null or empty");
        }
        this.dataObjectFormatIdentifierDocumentationReferences = new ArrayList<String>(dataObjectFormatIdentifierDocumentationReferences);
    }

    public List<String> getSignerClaimedRoles() {
        return this.signerClaimedRoles;
    }

    public void setSignerClaimedRoles(List<String> signerClaimedRoles) {
        if (signerClaimedRoles == null) {
            throw new IllegalArgumentException("Parameter 'signerClaimedRoles' is null");
        }
        for (String role : signerClaimedRoles) {
            if (role != null && !role.isEmpty()) continue;
            throw new IllegalArgumentException("At least one of the signer claimed roles is null or empty");
        }
        this.signerClaimedRoles = new ArrayList<String>(signerClaimedRoles);
    }

    public List<XAdESEncapsulatedPKIData> getSignerCertifiedRoles() {
        return this.signerCertifiedRoles;
    }

    public void setSignerCertifiedRoles(List<XAdESEncapsulatedPKIData> signerCertifiedRoles) {
        if (signerCertifiedRoles == null) {
            throw new IllegalArgumentException("Parameter 'signerCertifiedRoles' is null");
        }
        for (XAdESEncapsulatedPKIData role : signerCertifiedRoles) {
            if (role != null) continue;
            throw new IllegalArgumentException("At least one of the signer certified roles is null");
        }
        this.signerCertifiedRoles = new ArrayList<XAdESEncapsulatedPKIData>(signerCertifiedRoles);
    }

    public String getSignatureProductionPlaceCity() {
        return this.signatureProductionPlaceCity;
    }

    public void setSignatureProductionPlaceCity(String signatureProductionPlaceCity) {
        this.signatureProductionPlaceCity = signatureProductionPlaceCity;
    }

    public String getSignatureProductionPlaceStateOrProvince() {
        return this.signatureProductionPlaceStateOrProvince;
    }

    public void setSignatureProductionPlaceStateOrProvince(String signatureProductionPlaceStateOrProvince) {
        this.signatureProductionPlaceStateOrProvince = signatureProductionPlaceStateOrProvince;
    }

    public String getSignatureProductionPlacePostalCode() {
        return this.signatureProductionPlacePostalCode;
    }

    public void setSignatureProductionPlacePostalCode(String signatureProductionPlacePostalCode) {
        this.signatureProductionPlacePostalCode = signatureProductionPlacePostalCode;
    }

    public String getSignatureProductionPlaceCountryName() {
        return this.signatureProductionPlaceCountryName;
    }

    public void setSignatureProductionPlaceCountryName(String signatureProductionPlaceCountryName) {
        this.signatureProductionPlaceCountryName = signatureProductionPlaceCountryName;
    }

    public String getCommitmentTypeId() {
        return this.commitmentTypeId;
    }

    public void setCommitmentTypeId(String commitmentTypeId) {
        this.commitmentTypeId = commitmentTypeId;
    }

    public String getCommitmentTypeIdQualifier() {
        return this.commitmentTypeIdQualifier;
    }

    public void setCommitmentTypeIdQualifier(String commitmentTypeIdQualifier) {
        this.commitmentTypeIdQualifier = commitmentTypeIdQualifier;
    }

    public String getCommitmentTypeIdDescription() {
        return this.commitmentTypeIdDescription;
    }

    public void setCommitmentTypeIdDescription(String commitmentTypeIdDescription) {
        this.commitmentTypeIdDescription = commitmentTypeIdDescription;
    }

    public List<String> getCommitmentTypeIdDocumentationReferences() {
        return this.commitmentTypeIdDocumentationReferences;
    }

    public void setCommitmentTypeIdDocumentationReferences(List<String> commitmentTypeIdDocumentationReferences) {
        if (commitmentTypeIdDocumentationReferences == null) {
            throw new IllegalArgumentException("Parameter 'commitmentTypeIdDocumentationReferences' is null");
        }
        for (String ref : commitmentTypeIdDocumentationReferences) {
            if (ref != null && !ref.isEmpty()) continue;
            throw new IllegalArgumentException("At least one documentation reference of the commitment type is null or empty");
        }
        this.commitmentTypeIdDocumentationReferences = new ArrayList<String>(commitmentTypeIdDocumentationReferences);
    }

    public List<String> getCommitmentTypeQualifiers() {
        return this.commitmentTypeQualifiers;
    }

    public void setCommitmentTypeQualifiers(List<String> commitmentTypeQualifiers) {
        if (commitmentTypeQualifiers == null) {
            throw new IllegalArgumentException("Parameter 'commitmentTypeQualifiers' is null");
        }
        for (String qualifier : commitmentTypeQualifiers) {
            if (qualifier != null && !qualifier.isEmpty()) continue;
            throw new IllegalArgumentException("At least one qualifier of the commitment type is null or empty");
        }
        this.commitmentTypeQualifiers = new ArrayList<String>(commitmentTypeQualifiers);
    }

    @Override
    public XmlSignatureProperties.Output get(XmlSignatureProperties.Input input) throws Exception {
        XmlSignatureProperties.Output result = new XmlSignatureProperties.Output();
        if (!this.isAddSignedSignatureProperties() && !this.isAddSignedDataObjectPropeties()) {
            LOG.debug("XAdES signature properties are empty. Therefore no XAdES element will be added to the signature.");
            return result;
        }
        String signedPropertiesId = "_" + UUID.randomUUID().toString();
        List transforms = Collections.emptyList();
        Reference ref = input.getSignatureFactory().newReference("#" + signedPropertiesId, input.getSignatureFactory().newDigestMethod(input.getContentDigestAlgorithm(), null), transforms, "http://uri.etsi.org/01903#SignedProperties", null);
        Node parent = input.getParent();
        Document doc = 9 == parent.getNodeType() ? (Document)parent : parent.getOwnerDocument();
        Element qualifyingProperties = this.createElement("QualifyingProperties", doc, input);
        this.setIdAttributeFromHeader("CamelXmlSignatureXAdESQualifyingPropertiesId", qualifyingProperties, input);
        String signatureId = input.getSignatureId();
        if (signatureId == null || signatureId.isEmpty()) {
            LOG.debug("No signature Id configured. Therefore a value is generated.");
            signatureId = "_" + UUID.randomUUID().toString();
            result.setSignatureId(signatureId);
        }
        this.setAttribute(qualifyingProperties, "Target", "#" + signatureId);
        Element signedProperties = this.createElement("SignedProperties", doc, input);
        qualifyingProperties.appendChild(signedProperties);
        this.setAttribute(signedProperties, "Id", signedPropertiesId);
        signedProperties.setIdAttribute("Id", true);
        this.addSignedSignatureProperties(doc, signedProperties, input);
        String contentReferenceId = this.addSignedDataObjectProperties(doc, signedProperties, input);
        result.setContentReferenceId(contentReferenceId);
        DOMStructure structure = new DOMStructure(qualifyingProperties);
        XMLObject propertiesObject = input.getSignatureFactory().newXMLObject(Collections.singletonList(structure), null, null, null);
        result.setReferences(Collections.singletonList(ref));
        result.setObjects(Collections.singletonList(propertiesObject));
        return result;
    }

    protected void setAttribute(Element element, String attrName, String value) {
        element.setAttributeNS("", attrName, value);
    }

    protected void setIdAttributeFromHeader(String header, Element element, XmlSignatureProperties.Input input) {
        String value = (String)input.getMessage().getHeader(header, String.class);
        if (value != null && !value.isEmpty()) {
            this.setAttribute(element, "Id", value);
            element.setIdAttribute("Id", true);
        }
    }

    protected String addSignedDataObjectProperties(Document doc, Element signedProperties, XmlSignatureProperties.Input input) throws XmlSignatureException, SAXException, IOException, ParserConfigurationException {
        if (this.isAddSignedDataObjectPropeties()) {
            Element signedDataObjectProperties = this.createElement("SignedDataObjectProperties", doc, input);
            this.setIdAttributeFromHeader("CamelXmlSignatureXAdESSignedDataObjectPropertiesId", signedDataObjectProperties, input);
            signedProperties.appendChild(signedDataObjectProperties);
            String contentReferenceId = this.addDataObjectFormat(signedDataObjectProperties, doc, input);
            this.addCommitmentTypeIndication(signedDataObjectProperties, doc, input);
            return contentReferenceId;
        }
        return null;
    }

    protected boolean isAddSignedDataObjectPropeties() {
        return this.isAddDataObjectFormat() || this.isAddCommitmentType();
    }

    protected void addCommitmentTypeIndication(Element signedDataObjectProperties, Document doc, XmlSignatureProperties.Input input) throws SAXException, IOException, ParserConfigurationException, XmlSignatureException {
        if (!this.isAddCommitmentType()) {
            return;
        }
        Element commitmentTypeIndication = this.createElement("CommitmentTypeIndication", doc, input);
        signedDataObjectProperties.appendChild(commitmentTypeIndication);
        Element commitmentTypeIdEl = this.createElement("CommitmentTypeId", doc, input);
        commitmentTypeIndication.appendChild(commitmentTypeIdEl);
        Element identifier = this.createElement("Identifier", doc, input);
        commitmentTypeIdEl.appendChild(identifier);
        identifier.setTextContent(this.getCommitmentTypeId());
        if (this.getCommitmentTypeIdQualifier() != null && !this.getCommitmentTypeIdQualifier().isEmpty()) {
            this.setAttribute(identifier, "Qualifier", this.getCommitmentTypeIdQualifier());
        }
        if (this.getCommitmentTypeIdDescription() != null && !this.getCommitmentTypeIdDescription().isEmpty()) {
            Element description = this.createElement("Description", doc, input);
            commitmentTypeIdEl.appendChild(description);
            description.setTextContent(this.getCommitmentTypeIdDescription());
        }
        if (!this.getCommitmentTypeIdDocumentationReferences().isEmpty()) {
            Element documentationReferences = this.createElement("DocumentationReferences", doc, input);
            commitmentTypeIdEl.appendChild(documentationReferences);
            List<String> docReferences = this.getCommitmentTypeIdDocumentationReferences();
            for (String documentationReferenceValue : docReferences) {
                Element documentationReference = this.createElement("DocumentationReference", doc, input);
                documentationReferences.appendChild(documentationReference);
                documentationReference.setTextContent(documentationReferenceValue);
            }
        }
        Element allSignedDataObjects = this.createElement("AllSignedDataObjects", doc, input);
        commitmentTypeIndication.appendChild(allSignedDataObjects);
        List<String> qualifiers = this.getCommitmentTypeQualifiers();
        if (!qualifiers.isEmpty()) {
            Element qualifiersEl = this.createElement("CommitmentTypeQualifiers", doc, input);
            commitmentTypeIndication.appendChild(qualifiersEl);
            String errorMessage = "The XAdES configuration is invalid. The list of the commitment type qualifiers contains the invalid entry '%s'. An entry must either be a text or an XML fragment with the root element '%s' with the namespace '%s'.";
            for (String qualifier : this.getCommitmentTypeQualifiers()) {
                Element qualifierEl = this.createChildFromXmlFragmentOrText(doc, input, "CommitmentTypeQualifier", errorMessage, qualifier);
                qualifiersEl.appendChild(qualifierEl);
            }
        }
    }

    protected boolean isAddCommitmentType() {
        return this.getCommitmentTypeId() != null && !this.getCommitmentTypeId().isEmpty();
    }

    protected String addDataObjectFormat(Element signedDataObjectProperties, Document doc, XmlSignatureProperties.Input input) throws XmlSignatureException {
        String encoding;
        if (!this.isAddDataObjectFormat()) {
            return null;
        }
        Element dataObjectFormat = this.createElement("DataObjectFormat", doc, input);
        signedDataObjectProperties.appendChild(dataObjectFormat);
        String contentReferenceId = "_" + UUID.randomUUID().toString();
        this.setAttribute(dataObjectFormat, "ObjectReference", "#" + contentReferenceId);
        if (this.getDataObjectFormatDescription() != null && !this.getDataObjectFormatDescription().isEmpty()) {
            Element description = this.createElement("Description", doc, input);
            dataObjectFormat.appendChild(description);
            description.setTextContent(this.getDataObjectFormatDescription());
        }
        if (this.getDataObjectFormatIdentifier() != null && !this.getDataObjectFormatIdentifier().isEmpty()) {
            Element objectIdentifier = this.createElement("ObjectIdentifier", doc, input);
            dataObjectFormat.appendChild(objectIdentifier);
            Element identifier = this.createElement("Identifier", doc, input);
            objectIdentifier.appendChild(identifier);
            identifier.setTextContent(this.getDataObjectFormatIdentifier());
            if (this.getDataObjectFormatIdentifierQualifier() != null && !this.getDataObjectFormatIdentifierQualifier().isEmpty()) {
                this.setAttribute(identifier, "Qualifier", this.getDataObjectFormatIdentifierQualifier());
            }
            if (this.getDataObjectFormatIdentifierDescription() != null && !this.getDataObjectFormatIdentifierDescription().isEmpty()) {
                Element description = this.createElement("Description", doc, input);
                objectIdentifier.appendChild(description);
                description.setTextContent(this.getDataObjectFormatIdentifierDescription());
            }
            if (!this.getDataObjectFormatIdentifierDocumentationReferences().isEmpty()) {
                Element documentationReferences = this.createElement("DocumentationReferences", doc, input);
                objectIdentifier.appendChild(documentationReferences);
                List<String> docReferences = this.getDataObjectFormatIdentifierDocumentationReferences();
                for (String documentationReferenceValue : docReferences) {
                    Element documentationReference = this.createElement("DocumentationReference", doc, input);
                    documentationReferences.appendChild(documentationReference);
                    documentationReference.setTextContent(documentationReferenceValue);
                }
            }
        }
        if (this.getDataObjectFormatMimeType() != null && !this.getDataObjectFormatMimeType().isEmpty()) {
            Element mimeType = this.createElement("MimeType", doc, input);
            dataObjectFormat.appendChild(mimeType);
            mimeType.setTextContent(this.getDataObjectFormatMimeType());
        }
        if ((encoding = (String)input.getMessage().getHeader("CamelXmlSignatureXAdESDataObjectFormatEncoding", String.class)) != null && !encoding.isEmpty()) {
            Element encodingEl = this.createElement("Encoding", doc, input);
            dataObjectFormat.appendChild(encodingEl);
            encodingEl.setTextContent(encoding);
        }
        return contentReferenceId;
    }

    protected boolean isAddDataObjectFormat() {
        return this.getDataObjectFormatIdentifier() != null && !this.getDataObjectFormatIdentifier().isEmpty() || this.getDataObjectFormatDescription() != null && !this.getDataObjectFormatDescription().isEmpty() || this.getDataObjectFormatMimeType() != null && !this.getDataObjectFormatMimeType().isEmpty();
    }

    protected void addSignedSignatureProperties(Document doc, Element signedProperties, XmlSignatureProperties.Input input) throws Exception {
        if (this.isAddSignedSignatureProperties()) {
            LOG.debug("Adding signed signature properties");
            Element signedSignatureProperties = this.createElement("SignedSignatureProperties", doc, input);
            this.setIdAttributeFromHeader("CamelXmlSignatureXAdESSignedSignaturePropertiesId", signedSignatureProperties, input);
            signedProperties.appendChild(signedSignatureProperties);
            this.addSigningTime(doc, signedSignatureProperties, input);
            this.addSigningCertificate(doc, signedSignatureProperties, input);
            this.addSignaturePolicyIdentifier(doc, signedSignatureProperties, input);
            this.addSignatureProductionPlace(doc, signedSignatureProperties, input);
            this.addSignerRole(doc, signedSignatureProperties, input);
        }
    }

    protected boolean isAddSignedSignatureProperties() throws Exception {
        return this.isAddSigningTime() || this.getSigningCertificate() != null || this.getSigningCertificateChain() != null && this.getSigningCertificateChain().length > 0 || this.isAddSignaturePolicy() || this.isAddSignatureProductionPlace() || this.isAddSignerRole();
    }

    protected boolean isAddSignerRole() {
        return !this.getSignerClaimedRoles().isEmpty() || !this.getSignerCertifiedRoles().isEmpty();
    }

    protected void addSignatureProductionPlace(Document doc, Element signedSignatureProperties, XmlSignatureProperties.Input input) {
        if (!this.isAddSignatureProductionPlace()) {
            return;
        }
        Element signatureProductionPlace = this.createElement("SignatureProductionPlace", doc, input);
        signedSignatureProperties.appendChild(signatureProductionPlace);
        if (this.getSignatureProductionPlaceCity() != null && !this.getSignatureProductionPlaceCity().isEmpty()) {
            LOG.debug("Adding production city");
            Element city = this.createElement("City", doc, input);
            signatureProductionPlace.appendChild(city);
            city.setTextContent(this.getSignatureProductionPlaceCity());
        }
        if (this.getSignatureProductionPlaceStateOrProvince() != null && !this.getSignatureProductionPlaceStateOrProvince().isEmpty()) {
            LOG.debug("Adding production state or province");
            Element stateOrProvince = this.createElement("StateOrProvince", doc, input);
            signatureProductionPlace.appendChild(stateOrProvince);
            stateOrProvince.setTextContent(this.getSignatureProductionPlaceStateOrProvince());
        }
        if (this.getSignatureProductionPlacePostalCode() != null && !this.getSignatureProductionPlacePostalCode().isEmpty()) {
            LOG.debug("Adding production postal code");
            Element postalCode = this.createElement("PostalCode", doc, input);
            signatureProductionPlace.appendChild(postalCode);
            postalCode.setTextContent(this.getSignatureProductionPlacePostalCode());
        }
        if (this.getSignatureProductionPlaceCountryName() != null && !this.getSignatureProductionPlaceCountryName().isEmpty()) {
            LOG.debug("Adding production country name");
            Element countryName = this.createElement("CountryName", doc, input);
            signatureProductionPlace.appendChild(countryName);
            countryName.setTextContent(this.getSignatureProductionPlaceCountryName());
        }
    }

    protected boolean isAddSignatureProductionPlace() {
        return ObjectHelper.isNotEmpty((Object)this.getSignatureProductionPlaceCity()) || ObjectHelper.isNotEmpty((Object)this.getSignatureProductionPlaceCountryName()) || ObjectHelper.isNotEmpty((Object)this.getSignatureProductionPlacePostalCode()) || ObjectHelper.isNotEmpty((Object)this.getSignatureProductionPlaceStateOrProvince());
    }

    protected void addSignerRole(Document doc, Element signedSignatureProperties, XmlSignatureProperties.Input input) throws XmlSignatureException, SAXException, IOException, ParserConfigurationException {
        List<XAdESEncapsulatedPKIData> certifiedRoles;
        if (!this.isAddSignerRole()) {
            return;
        }
        Element signerRole = this.createElement("SignerRole", doc, input);
        signedSignatureProperties.appendChild(signerRole);
        List<String> claimedRoles = this.getSignerClaimedRoles();
        if (!claimedRoles.isEmpty()) {
            LOG.debug("Adding claimed roles");
            Element claimedRolesEl = this.createElement("ClaimedRoles", doc, input);
            signerRole.appendChild(claimedRolesEl);
            String errorMessage = "The XAdES configuration is invalid. The list of the claimed roles contains the invalid entry '%s'. An entry must either be a text or an XML fragment with the root element '%s' with the namespace '%s'.";
            for (String claimedRole : claimedRoles) {
                Element claimedRoleEl = this.createChildFromXmlFragmentOrText(doc, input, "ClaimedRole", errorMessage, claimedRole);
                claimedRolesEl.appendChild(claimedRoleEl);
            }
        }
        if (!(certifiedRoles = this.getSignerCertifiedRoles()).isEmpty()) {
            LOG.debug("Adding certified roles");
            Element certifiedRolesEl = this.createElement("CertifiedRoles", doc, input);
            signerRole.appendChild(certifiedRolesEl);
            for (XAdESEncapsulatedPKIData certifiedRole : certifiedRoles) {
                Element certifiedRoleEl = this.createElement("CertifiedRole", doc, input);
                certifiedRolesEl.appendChild(certifiedRoleEl);
                certifiedRoleEl.setTextContent(certifiedRole.getBase64Conent());
                if (certifiedRole.getEncoding() != null && !certifiedRole.getEncoding().isEmpty()) {
                    this.setAttribute(certifiedRoleEl, "Encoding", certifiedRole.getEncoding());
                }
                if (certifiedRole.getId() == null || certifiedRole.getId().isEmpty()) continue;
                this.setAttribute(certifiedRoleEl, "Id", certifiedRole.getId());
                certifiedRoleEl.setIdAttribute("Id", true);
            }
        }
    }

    protected void addSignaturePolicyIdentifier(Document doc, Element signedProperties, XmlSignatureProperties.Input input) throws XmlSignatureException, SAXException, IOException, ParserConfigurationException {
        if (!this.isAddSignaturePolicy()) {
            return;
        }
        Element signaturePolicyIdentifier = this.createElement("SignaturePolicyIdentifier", doc, input);
        signedProperties.appendChild(signaturePolicyIdentifier);
        if (SIG_POLICY_IMPLIED.equals(this.getSignaturePolicy())) {
            LOG.debug("Adding implied signature policy");
            Element implied = this.createElement("SignaturePolicyImplied", doc, input);
            signaturePolicyIdentifier.appendChild(implied);
        } else if (SIG_POLICY_EXPLICIT_ID.equals(this.getSignaturePolicy())) {
            LOG.debug("Adding signatue policy ID");
            Element id = this.createElement("SignaturePolicyId", doc, input);
            signaturePolicyIdentifier.appendChild(id);
            Element sigPolicyId = this.createElement("SigPolicyId", doc, input);
            id.appendChild(sigPolicyId);
            Element identifier = this.createElement("Identifier", doc, input);
            sigPolicyId.appendChild(identifier);
            if (this.getSigPolicyId() == null || this.getSigPolicyId().isEmpty()) {
                throw new XmlSignatureException("The XAdES-EPES configuration is invalid. The signature policy identifier is missing.");
            }
            identifier.setTextContent(this.getSigPolicyId());
            if (this.getSigPolicyIdQualifier() != null && !this.getSigPolicyIdQualifier().isEmpty()) {
                this.setAttribute(identifier, "Qualifier", this.getSigPolicyIdQualifier());
            }
            if (this.getSigPolicyIdDescription() != null && !this.getSigPolicyIdDescription().isEmpty()) {
                Element description = this.createElement("Description", doc, input);
                sigPolicyId.appendChild(description);
                description.setTextContent(this.getSigPolicyIdDescription());
            }
            if (!this.getSigPolicyIdDocumentationReferences().isEmpty()) {
                Element documentationReferences = this.createElement("DocumentationReferences", doc, input);
                sigPolicyId.appendChild(documentationReferences);
                List<String> docReferences = this.getSigPolicyIdDocumentationReferences();
                for (String documentationReferenceValue : docReferences) {
                    Element documentationReference = this.createElement("DocumentationReference", doc, input);
                    documentationReferences.appendChild(documentationReference);
                    documentationReference.setTextContent(documentationReferenceValue);
                }
            }
            Element sigPolicyHash = this.createElement("SigPolicyHash", doc, input);
            id.appendChild(sigPolicyHash);
            if (this.getSignaturePolicyDigestAlgorithm() == null || this.getSignaturePolicyDigestAlgorithm().isEmpty()) {
                throw new XmlSignatureException("The XAdES-EPES configuration is invalid. The digest algorithm for the signature policy is missing.");
            }
            Element digestMethod = this.createElementNS(doc, input, "DigestMethod");
            sigPolicyHash.appendChild(digestMethod);
            this.setAttribute(digestMethod, "Algorithm", this.getSignaturePolicyDigestAlgorithm());
            if (this.getSignaturePolicyDigestValue() == null || this.getSignaturePolicyDigestValue().isEmpty()) {
                throw new XmlSignatureException("The XAdES-EPES configuration is invalid. The digest value for the signature policy is missing.");
            }
            Element digestValue = this.createElementNS(doc, input, "DigestValue");
            sigPolicyHash.appendChild(digestValue);
            digestValue.setTextContent(this.getSignaturePolicyDigestValue());
            List<String> qualifiers = this.getSigPolicyQualifiers();
            if (!qualifiers.isEmpty()) {
                Element qualifiersEl = this.createElement("SigPolicyQualifiers", doc, input);
                id.appendChild(qualifiersEl);
                String errorMessage = "The XAdES configuration is invalid. The list of the signatue policy qualifiers contains the invalid entry '%s'. An entry must either be a text or an XML fragment with the root element '%s' with the namespace '%s'.";
                for (String elementOrText : this.getSigPolicyQualifiers()) {
                    Element child = this.createChildFromXmlFragmentOrText(doc, input, "SigPolicyQualifier", errorMessage, elementOrText);
                    qualifiersEl.appendChild(child);
                }
            }
        } else {
            throw new IllegalStateException(String.format("Invalid value '%s' for parameter 'SignaturePolicy'. Possible values are: 'None', 'Implied', and 'ExplictId'.", this.getSignaturePolicy()));
        }
    }

    protected Element createChildFromXmlFragmentOrText(Document doc, XmlSignatureProperties.Input input, String localElementName, String errorMessage, String elementOrText) throws IOException, ParserConfigurationException, XmlSignatureException {
        Element child;
        block4: {
            String ending = localElementName + ">";
            if (elementOrText.startsWith("<") && elementOrText.endsWith(ending)) {
                try {
                    InputSource source = new InputSource(new StringReader(elementOrText));
                    source.setEncoding("UTF-8");
                    Document parsedDoc = XmlSignatureHelper.newDocumentBuilder(Boolean.TRUE).parse(source);
                    this.replacePrefixes(parsedDoc, input);
                    child = (Element)doc.adoptNode(parsedDoc.getDocumentElement());
                    String ns = this.findNamespace(input.getMessage());
                    if (!ns.equals(child.getNamespaceURI())) {
                        throw new XmlSignatureException(String.format("The XAdES configuration is invalid. The root element '%s' of the provided XML fragment '%s' has the invalid namespace '%s'. The correct namespace is '%s'.", child.getLocalName(), elementOrText, child.getNamespaceURI(), ns));
                    }
                    break block4;
                }
                catch (SAXException e) {
                    throw new XmlSignatureException(String.format(errorMessage, elementOrText, localElementName, this.namespace), e);
                }
            }
            child = this.createElement(localElementName, doc, input);
            child.setTextContent(elementOrText);
        }
        return child;
    }

    protected void replacePrefixes(Document qualifierDoc, XmlSignatureProperties.Input input) {
        Element el = qualifierDoc.getDocumentElement();
        this.replacePrefix(el, input);
        List<Element> childElements = this.getChildElements(el);
        ArrayList<Element> collectedNewChildElements = new ArrayList<Element>();
        while (!childElements.isEmpty()) {
            collectedNewChildElements.clear();
            for (Element child : childElements) {
                this.replacePrefix(child, input);
                List<Element> newChildElements = this.getChildElements(child);
                collectedNewChildElements.addAll(newChildElements);
            }
            childElements = new ArrayList<Element>(collectedNewChildElements);
        }
    }

    protected List<Element> getChildElements(Element el) {
        ArrayList<Element> childElements = new ArrayList<Element>(5);
        NodeList children = el.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType()) continue;
            childElements.add((Element)child);
        }
        return childElements;
    }

    protected void replacePrefix(Element el, XmlSignatureProperties.Input input) {
        this.replacePrefixForNode(el, input);
        NamedNodeMap nnm = el.getAttributes();
        ArrayList<Attr> xmlnsToBeRemoved = new ArrayList<Attr>(2);
        int length = nnm.getLength();
        for (int i = 0; i < length; ++i) {
            Node attr = nnm.item(i);
            this.replacePrefixForNode(attr, input);
            if (attr.getNodeType() != 2 || !"xmlns".equals(attr.getLocalName()) && !"xmlns".equals(attr.getPrefix()) || !"http://www.w3.org/2000/09/xmldsig#".equals(attr.getTextContent()) && !this.findNamespace(input.getMessage()).equals(attr.getTextContent())) continue;
            xmlnsToBeRemoved.add((Attr)attr);
        }
        for (Attr toBeRemoved : xmlnsToBeRemoved) {
            el.removeAttributeNode(toBeRemoved);
        }
    }

    protected void replacePrefixForNode(Node node, XmlSignatureProperties.Input input) {
        if ("http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI())) {
            node.setPrefix(input.getPrefixForXmlSignatureNamespace());
        } else if (this.findNamespace(input.getMessage()).equals(node.getNamespaceURI())) {
            node.setPrefix(this.findPrefix(input.getMessage()));
        }
    }

    protected boolean isAddSignaturePolicy() {
        return !SIG_POLICY_NONE.equals(this.getSignaturePolicy());
    }

    protected void addSigningCertificate(Document doc, Element signedProperties, XmlSignatureProperties.Input input) throws Exception {
        if (this.getSigningCertificate() == null && (this.getSigningCertificateChain() == null || this.getSigningCertificateChain().length == 0)) {
            return;
        }
        Element signedCertificate = this.createElement("SigningCertificate", doc, input);
        signedProperties.appendChild(signedCertificate);
        if (this.getSigningCertificate() != null) {
            LOG.debug("Adding signing certificate");
            X509Certificate cert = this.getSigningCertificate();
            this.addCertificate(cert, signedCertificate, doc, 0, input);
        } else if (this.getSigningCertificateChain() != null && this.getSigningCertificateChain().length > 0) {
            X509Certificate[] certs = this.getSigningCertificateChain();
            int index = 0;
            for (X509Certificate cert : certs) {
                LOG.debug("Adding chain certtificate {}", (Object)index);
                X509Certificate x509Cert = cert;
                this.addCertificate(x509Cert, signedCertificate, doc, index, input);
                ++index;
            }
        } else {
            throw new IllegalStateException("Unexpected exception");
        }
    }

    protected X509Certificate getSigningCertificate() throws Exception {
        return null;
    }

    protected X509Certificate[] getSigningCertificateChain() throws Exception {
        return null;
    }

    protected void addSigningTime(Document doc, Element signedProperties, XmlSignatureProperties.Input input) {
        if (this.isAddSigningTime()) {
            LOG.debug("Adding signing time");
            Element signingTime = this.createElement("SigningTime", doc, input);
            signedProperties.appendChild(signingTime);
            Date current = new Date();
            signingTime.setTextContent(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(current));
        }
    }

    protected void addCertificate(X509Certificate cert, Element signedCertificate, Document doc, int index, XmlSignatureProperties.Input input) throws CertificateEncodingException, NoSuchAlgorithmException, XmlSignatureException {
        String uri;
        Element elCert = this.createElement("Cert", doc, input);
        signedCertificate.appendChild(elCert);
        String algorithm = this.getMessageDigestAlgorithm(this.getDigestAlgorithmForSigningCertificate(), "The digest algorithm '%s' for the signing certificate is invalid");
        String digest = this.calculateDigest(algorithm, cert.getEncoded());
        Element certDigest = this.createElement("CertDigest", doc, input);
        elCert.appendChild(certDigest);
        Element digestMethod = this.createElementNS(doc, input, "DigestMethod");
        certDigest.appendChild(digestMethod);
        this.setAttribute(digestMethod, "Algorithm", this.getDigestAlgorithmForSigningCertificate());
        Element digestValue = this.createElementNS(doc, input, "DigestValue");
        certDigest.appendChild(digestValue);
        digestValue.setTextContent(digest);
        Element issuerSerial = this.createElement("IssuerSerial", doc, input);
        elCert.appendChild(issuerSerial);
        Element x509IssuerName = this.createDigSigElement("X509IssuerName", doc, input.getPrefixForXmlSignatureNamespace());
        issuerSerial.appendChild(x509IssuerName);
        x509IssuerName.setTextContent(cert.getIssuerX500Principal().getName("RFC2253"));
        Element x509SerialNumber = this.createDigSigElement("X509SerialNumber", doc, input.getPrefixForXmlSignatureNamespace());
        issuerSerial.appendChild(x509SerialNumber);
        x509SerialNumber.setTextContent(cert.getSerialNumber().toString());
        List<String> uris = this.getSigningCertificateURIs();
        if (!uris.isEmpty() && uris.size() > index && (uri = uris.get(index)) != null && !uri.isEmpty()) {
            this.setAttribute(elCert, "URI", uri);
        }
    }

    protected String getMessageDigestAlgorithm(String xmlSigDigestMethod, String errorMessage) throws XmlSignatureException {
        String algorithm;
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(xmlSigDigestMethod)) {
            algorithm = "SHA-1";
        } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(xmlSigDigestMethod)) {
            algorithm = "SHA-256";
        } else if ("http://www.w3.org/2001/04/xmldsig-more#sha384".equals(xmlSigDigestMethod)) {
            algorithm = "SHA-384";
        } else if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(this.getDigestAlgorithmForSigningCertificate())) {
            algorithm = "SHA-512";
        } else {
            throw new XmlSignatureException(String.format(errorMessage, xmlSigDigestMethod));
        }
        return algorithm;
    }

    protected String calculateDigest(String algorithm, byte[] bytes) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] digestBytes = digest.digest(bytes);
        return new Base64().encodeAsString(digestBytes);
    }

    protected Element createElementNS(Document doc, XmlSignatureProperties.Input input, String elementName) {
        Element digestMethod = HTTP_URI_ETSI_ORG_01903_V1_1_1.equals(this.findNamespace(input.getMessage())) ? this.createElement(elementName, doc, input) : this.createDigSigElement(elementName, doc, input.getPrefixForXmlSignatureNamespace());
        return digestMethod;
    }

    protected Element createDigSigElement(String localName, Document doc, String prefixForXmlSignatureNamespace) {
        Element el = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", localName);
        if (prefixForXmlSignatureNamespace != null && !prefixForXmlSignatureNamespace.isEmpty()) {
            el.setPrefix(prefixForXmlSignatureNamespace);
        }
        return el;
    }

    protected Element createElement(String localName, Document doc, XmlSignatureProperties.Input input) {
        Element el = doc.createElementNS(this.findNamespace(input.getMessage()), localName);
        String p = this.findPrefix(input.getMessage());
        if (p != null && !p.isEmpty()) {
            el.setPrefix(p);
        }
        return el;
    }

    static {
        SIG_POLICY_VALUES.add(SIG_POLICY_NONE);
        SIG_POLICY_VALUES.add(SIG_POLICY_IMPLIED);
        SIG_POLICY_VALUES.add(SIG_POLICY_EXPLICIT_ID);
    }
}

