/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.util.List;
import java.util.Map;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.CamelContext;
import org.apache.camel.component.xmlsecurity.XmlSignerComponent;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class XmlSignerComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private XmlSignerConfiguration getOrCreateSignerConfiguration(XmlSignerComponent target) {
        if (target.getSignerConfiguration() == null) {
            target.setSignerConfiguration(new XmlSignerConfiguration());
        }
        return target.getSignerConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        XmlSignerComponent target = (XmlSignerComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "addkeyinforeference": 
            case "addKeyInfoReference": {
                this.getOrCreateSignerConfiguration(target).setAddKeyInfoReference((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "baseuri": 
            case "baseUri": {
                this.getOrCreateSignerConfiguration(target).setBaseUri((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "canonicalizationmethod": 
            case "canonicalizationMethod": {
                this.getOrCreateSignerConfiguration(target).setCanonicalizationMethod((AlgorithmMethod)XmlSignerComponentConfigurer.property((CamelContext)camelContext, AlgorithmMethod.class, (Object)value));
                return true;
            }
            case "clearheaders": 
            case "clearHeaders": {
                this.getOrCreateSignerConfiguration(target).setClearHeaders((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "contentobjectid": 
            case "contentObjectId": {
                this.getOrCreateSignerConfiguration(target).setContentObjectId((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentreferencetype": 
            case "contentReferenceType": {
                this.getOrCreateSignerConfiguration(target).setContentReferenceType((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "contentreferenceuri": 
            case "contentReferenceUri": {
                this.getOrCreateSignerConfiguration(target).setContentReferenceUri((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cryptocontextproperties": 
            case "cryptoContextProperties": {
                this.getOrCreateSignerConfiguration(target).setCryptoContextProperties((Map)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "digestalgorithm": 
            case "digestAlgorithm": {
                this.getOrCreateSignerConfiguration(target).setDigestAlgorithm((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "disallowdoctypedecl": 
            case "disallowDoctypeDecl": {
                this.getOrCreateSignerConfiguration(target).setDisallowDoctypeDecl((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "keyaccessor": 
            case "keyAccessor": {
                this.getOrCreateSignerConfiguration(target).setKeyAccessor((KeyAccessor)XmlSignerComponentConfigurer.property((CamelContext)camelContext, KeyAccessor.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "omitxmldeclaration": 
            case "omitXmlDeclaration": {
                this.getOrCreateSignerConfiguration(target).setOmitXmlDeclaration((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "outputxmlencoding": 
            case "outputXmlEncoding": {
                this.getOrCreateSignerConfiguration(target).setOutputXmlEncoding((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentlocalname": 
            case "parentLocalName": {
                this.getOrCreateSignerConfiguration(target).setParentLocalName((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentnamespace": 
            case "parentNamespace": {
                this.getOrCreateSignerConfiguration(target).setParentNamespace((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "parentxpath": 
            case "parentXpath": {
                this.getOrCreateSignerConfiguration(target).setParentXpath((XPathFilterParameterSpec)XmlSignerComponentConfigurer.property((CamelContext)camelContext, XPathFilterParameterSpec.class, (Object)value));
                return true;
            }
            case "plaintext": 
            case "plainText": {
                this.getOrCreateSignerConfiguration(target).setPlainText((Boolean)XmlSignerComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "plaintextencoding": 
            case "plainTextEncoding": {
                this.getOrCreateSignerConfiguration(target).setPlainTextEncoding((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefixforxmlsignaturenamespace": 
            case "prefixForXmlSignatureNamespace": {
                this.getOrCreateSignerConfiguration(target).setPrefixForXmlSignatureNamespace((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "properties": {
                this.getOrCreateSignerConfiguration(target).setProperties((XmlSignatureProperties)XmlSignerComponentConfigurer.property((CamelContext)camelContext, XmlSignatureProperties.class, (Object)value));
                return true;
            }
            case "schemaresourceuri": 
            case "schemaResourceUri": {
                this.getOrCreateSignerConfiguration(target).setSchemaResourceUri((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signaturealgorithm": 
            case "signatureAlgorithm": {
                this.getOrCreateSignerConfiguration(target).setSignatureAlgorithm((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signatureid": 
            case "signatureId": {
                this.getOrCreateSignerConfiguration(target).setSignatureId((String)XmlSignerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signerconfiguration": 
            case "signerConfiguration": {
                target.setSignerConfiguration((XmlSignerConfiguration)XmlSignerComponentConfigurer.property((CamelContext)camelContext, XmlSignerConfiguration.class, (Object)value));
                return true;
            }
            case "transformmethods": 
            case "transformMethods": {
                this.getOrCreateSignerConfiguration(target).setTransformMethods((List)XmlSignerComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "uridereferencer": 
            case "uriDereferencer": {
                this.getOrCreateSignerConfiguration(target).setUriDereferencer((URIDereferencer)XmlSignerComponentConfigurer.property((CamelContext)camelContext, URIDereferencer.class, (Object)value));
                return true;
            }
            case "xpathstoidattributes": 
            case "xpathsToIdAttributes": {
                this.getOrCreateSignerConfiguration(target).setXpathsToIdAttributes((List)XmlSignerComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        XmlSignerComponent target = (XmlSignerComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "addkeyinforeference": 
            case "addKeyInfoReference": {
                return this.getOrCreateSignerConfiguration(target).getAddKeyInfoReference();
            }
            case "baseuri": 
            case "baseUri": {
                return this.getOrCreateSignerConfiguration(target).getBaseUri();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "canonicalizationmethod": 
            case "canonicalizationMethod": {
                return this.getOrCreateSignerConfiguration(target).getCanonicalizationMethod();
            }
            case "clearheaders": 
            case "clearHeaders": {
                return this.getOrCreateSignerConfiguration(target).getClearHeaders();
            }
            case "contentobjectid": 
            case "contentObjectId": {
                return this.getOrCreateSignerConfiguration(target).getContentObjectId();
            }
            case "contentreferencetype": 
            case "contentReferenceType": {
                return this.getOrCreateSignerConfiguration(target).getContentReferenceType();
            }
            case "contentreferenceuri": 
            case "contentReferenceUri": {
                return this.getOrCreateSignerConfiguration(target).getContentReferenceUri();
            }
            case "cryptocontextproperties": 
            case "cryptoContextProperties": {
                return this.getOrCreateSignerConfiguration(target).getCryptoContextProperties();
            }
            case "digestalgorithm": 
            case "digestAlgorithm": {
                return this.getOrCreateSignerConfiguration(target).getDigestAlgorithm();
            }
            case "disallowdoctypedecl": 
            case "disallowDoctypeDecl": {
                return this.getOrCreateSignerConfiguration(target).getDisallowDoctypeDecl();
            }
            case "keyaccessor": 
            case "keyAccessor": {
                return this.getOrCreateSignerConfiguration(target).getKeyAccessor();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "omitxmldeclaration": 
            case "omitXmlDeclaration": {
                return this.getOrCreateSignerConfiguration(target).getOmitXmlDeclaration();
            }
            case "outputxmlencoding": 
            case "outputXmlEncoding": {
                return this.getOrCreateSignerConfiguration(target).getOutputXmlEncoding();
            }
            case "parentlocalname": 
            case "parentLocalName": {
                return this.getOrCreateSignerConfiguration(target).getParentLocalName();
            }
            case "parentnamespace": 
            case "parentNamespace": {
                return this.getOrCreateSignerConfiguration(target).getParentNamespace();
            }
            case "parentxpath": 
            case "parentXpath": {
                return this.getOrCreateSignerConfiguration(target).getParentXpath();
            }
            case "plaintext": 
            case "plainText": {
                return this.getOrCreateSignerConfiguration(target).getPlainText();
            }
            case "plaintextencoding": 
            case "plainTextEncoding": {
                return this.getOrCreateSignerConfiguration(target).getPlainTextEncoding();
            }
            case "prefixforxmlsignaturenamespace": 
            case "prefixForXmlSignatureNamespace": {
                return this.getOrCreateSignerConfiguration(target).getPrefixForXmlSignatureNamespace();
            }
            case "properties": {
                return this.getOrCreateSignerConfiguration(target).getProperties();
            }
            case "schemaresourceuri": 
            case "schemaResourceUri": {
                return this.getOrCreateSignerConfiguration(target).getSchemaResourceUri();
            }
            case "signaturealgorithm": 
            case "signatureAlgorithm": {
                return this.getOrCreateSignerConfiguration(target).getSignatureAlgorithm();
            }
            case "signatureid": 
            case "signatureId": {
                return this.getOrCreateSignerConfiguration(target).getSignatureId();
            }
            case "signerconfiguration": 
            case "signerConfiguration": {
                return target.getSignerConfiguration();
            }
            case "transformmethods": 
            case "transformMethods": {
                return this.getOrCreateSignerConfiguration(target).getTransformMethods();
            }
            case "uridereferencer": 
            case "uriDereferencer": {
                return this.getOrCreateSignerConfiguration(target).getUriDereferencer();
            }
            case "xpathstoidattributes": 
            case "xpathsToIdAttributes": {
                return this.getOrCreateSignerConfiguration(target).getXpathsToIdAttributes();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("addKeyInfoReference", Boolean.class);
        map.put("baseUri", String.class);
        map.put("canonicalizationMethod", AlgorithmMethod.class);
        map.put("clearHeaders", Boolean.class);
        map.put("contentObjectId", String.class);
        map.put("contentReferenceType", String.class);
        map.put("contentReferenceUri", String.class);
        map.put("cryptoContextProperties", Map.class);
        map.put("digestAlgorithm", String.class);
        map.put("disallowDoctypeDecl", Boolean.class);
        map.put("keyAccessor", KeyAccessor.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("omitXmlDeclaration", Boolean.class);
        map.put("outputXmlEncoding", String.class);
        map.put("parentLocalName", String.class);
        map.put("parentNamespace", String.class);
        map.put("parentXpath", XPathFilterParameterSpec.class);
        map.put("plainText", Boolean.class);
        map.put("plainTextEncoding", String.class);
        map.put("prefixForXmlSignatureNamespace", String.class);
        map.put("properties", XmlSignatureProperties.class);
        map.put("schemaResourceUri", String.class);
        map.put("signatureAlgorithm", String.class);
        map.put("signatureId", String.class);
        map.put("transformMethods", List.class);
        map.put("xpathsToIdAttributes", List.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("signerConfiguration", XmlSignerConfiguration.class);
        map.put("uriDereferencer", URIDereferencer.class);
        ALL_OPTIONS = map;
    }
}

