/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class CollectionConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        CollectionConverterLoader.addTypeConverter(registry, Object[].class, Collection.class, false, (type, exchange, value) -> CollectionConverter.toArray((Collection)value));
        CollectionConverterLoader.addTypeConverter(registry, ArrayList.class, Iterator.class, false, (type, exchange, value) -> CollectionConverter.toArrayList((Iterator)value));
        CollectionConverterLoader.addTypeConverter(registry, HashMap.class, Map.class, false, (type, exchange, value) -> CollectionConverter.toHashMap((Map)value));
        CollectionConverterLoader.addTypeConverter(registry, Hashtable.class, Map.class, false, (type, exchange, value) -> CollectionConverter.toHashtable((Map)value));
        CollectionConverterLoader.addTypeConverter(registry, List.class, Iterable.class, false, (type, exchange, value) -> CollectionConverter.toList((Iterable)value));
        CollectionConverterLoader.addTypeConverter(registry, List.class, Object[].class, false, (type, exchange, value) -> CollectionConverter.toList((Object[])value));
        CollectionConverterLoader.addTypeConverter(registry, List.class, Collection.class, false, (type, exchange, value) -> CollectionConverter.toList((Collection)value));
        CollectionConverterLoader.addTypeConverter(registry, Properties.class, Map.class, false, (type, exchange, value) -> CollectionConverter.toProperties((Map)value));
        CollectionConverterLoader.addTypeConverter(registry, Set.class, Object[].class, false, (type, exchange, value) -> CollectionConverter.toSet((Object[])value));
        CollectionConverterLoader.addTypeConverter(registry, Set.class, Collection.class, false, (type, exchange, value) -> CollectionConverter.toSet((Collection)value));
        CollectionConverterLoader.addTypeConverter(registry, Set.class, Map.class, false, (type, exchange, value) -> CollectionConverter.toSet((Map)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

