/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureFormatException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidException;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureProcessor;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.apache.camel.support.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlVerifierProcessor
extends XmlSignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlVerifierProcessor.class);
    private final XmlVerifierConfiguration config;

    public XmlVerifierProcessor(CamelContext context, XmlVerifierConfiguration config) {
        super(context);
        this.config = config;
    }

    @Override
    public XmlVerifierConfiguration getConfiguration() {
        return this.config;
    }

    public void process(Exchange exchange) throws Exception {
        InputStream stream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            this.verify(stream, out);
            this.clearMessageHeaders(out);
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
        finally {
            IOHelper.close((Closeable)stream, (String)"input stream");
        }
    }

    protected void verify(InputStream input, Message out) throws Exception {
        XMLSignatureFactory fac;
        LOG.debug("Verification of XML signature document started");
        Document doc = this.parseInput(input, out);
        try {
            fac = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            fac = XMLSignatureFactory.getInstance("DOM");
        }
        KeySelector selector = this.getConfiguration().getKeySelector();
        if (selector == null) {
            throw new IllegalStateException("Wrong configuration. Key selector is missing.");
        }
        DOMValidateContext valContext = new DOMValidateContext(selector, (Node)doc);
        valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
        valContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
        if (this.getConfiguration().getSecureValidation() == Boolean.TRUE) {
            valContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            valContext.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        }
        this.setUriDereferencerAndBaseUri(valContext);
        this.setCryptoContextProperties(valContext);
        NodeList signatureNodes = this.getSignatureNodes(doc);
        ArrayList<XMLObject> collectedObjects = new ArrayList<XMLObject>(3);
        ArrayList<Reference> collectedReferences = new ArrayList<Reference>(3);
        int totalCount = signatureNodes.getLength();
        for (int i = 0; i < totalCount; ++i) {
            boolean coreValidity;
            Element signatureNode = (Element)signatureNodes.item(i);
            valContext.setNode(signatureNode);
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            if (this.getConfiguration().getXmlSignatureChecker() != null) {
                XmlSignatureChecker.Input checkerInput = new CheckerInputBuilder().message(out).messageBodyDocument(doc).keyInfo(signature.getKeyInfo()).currentCountOfSignatures(i + 1).currentSignatureElement(signatureNode).objects(signature.getObjects()).signatureValue(signature.getSignatureValue()).signedInfo(signature.getSignedInfo()).totalCountOfSignatures(totalCount).xmlSchemaValidationExecuted(this.getSchemaResourceUri(out) != null).build();
                this.getConfiguration().getXmlSignatureChecker().checkBeforeCoreValidation(checkerInput);
            }
            try {
                coreValidity = signature.validate(valContext);
            }
            catch (XMLSignatureException se) {
                throw this.getConfiguration().getValidationFailedHandler().onXMLSignatureException(se);
            }
            boolean goon = coreValidity;
            if (!coreValidity) {
                goon = this.handleSignatureValidationFailed(valContext, signature);
            }
            if (!goon) {
                throw new XmlSignatureInvalidException("XML signature validation failed");
            }
            LOG.debug("XML signature {} verified", (Object)(i + 1));
            collectedObjects.addAll(signature.getObjects());
            collectedReferences.addAll(signature.getSignedInfo().getReferences());
        }
        this.map2Message(collectedReferences, collectedObjects, out, doc);
    }

    private void map2Message(final List<Reference> refs, final List<XMLObject> objs, Message out, final Document messageBodyDocument) throws Exception {
        XmlSignature2Message.Input refsAndObjects = new XmlSignature2Message.Input(){

            @Override
            public List<Reference> getReferences() {
                return refs;
            }

            @Override
            public List<XMLObject> getObjects() {
                return objs;
            }

            @Override
            public Document getMessageBodyDocument() {
                return messageBodyDocument;
            }

            @Override
            public Boolean omitXmlDeclaration() {
                return XmlVerifierProcessor.this.getConfiguration().getOmitXmlDeclaration();
            }

            @Override
            public Object getOutputNodeSearch() {
                return XmlVerifierProcessor.this.getConfiguration().getOutputNodeSearch();
            }

            @Override
            public String getOutputNodeSearchType() {
                return XmlVerifierProcessor.this.getConfiguration().getOutputNodeSearchType();
            }

            @Override
            public Boolean getRemoveSignatureElements() {
                return XmlVerifierProcessor.this.getConfiguration().getRemoveSignatureElements();
            }

            @Override
            public String getOutputXmlEncoding() {
                return XmlVerifierProcessor.this.getConfiguration().getOutputXmlEncoding();
            }
        };
        this.getConfiguration().getXmlSignature2Message().mapToMessage(refsAndObjects, out);
    }

    private NodeList getSignatureNodes(Document doc) throws IOException, ParserConfigurationException, XmlSignatureFormatException {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new XmlSignatureFormatException("Message is not a correct XML signature document: 'Signature' element is missing. Check the sent message.");
        }
        LOG.debug("{} signature elements found", (Object)nl.getLength());
        return nl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSignatureValidationFailed(DOMValidateContext valContext, XMLSignature signature) throws Exception {
        ValidationFailedHandler handler = this.getConfiguration().getValidationFailedHandler();
        LOG.debug("handleSignatureValidationFailed called");
        try {
            handler.start();
            XMLSignature.SignatureValue sigValue = signature.getSignatureValue();
            boolean sv = sigValue.validate(valContext);
            if (!sv) {
                handler.signatureValueValidationFailed(sigValue);
            }
            for (Reference ref : signature.getSignedInfo().getReferences()) {
                boolean refValid = ref.validate(valContext);
                if (refValid) continue;
                handler.referenceValidationFailed(ref);
            }
            if (Boolean.TRUE.equals(valContext.getProperty("org.jcp.xml.dsig.validateManifests"))) {
                for (XMLObject xo : signature.getObjects()) {
                    List<XMLStructure> content = xo.getContent();
                    for (XMLStructure xs : content) {
                        if (!(xs instanceof Manifest)) continue;
                        Manifest man = (Manifest)xs;
                        for (Reference ref : man.getReferences()) {
                            boolean refValid = ref.validate(valContext);
                            if (refValid) continue;
                            handler.manifestReferenceValidationFailed(ref);
                        }
                    }
                }
            }
            boolean goon = handler.ignoreCoreValidationFailure();
            LOG.debug("Ignore Core Validation failure: {}", (Object)goon);
            boolean bl = goon;
            return bl;
        }
        finally {
            handler.end();
        }
    }

    protected Document parseInput(InputStream is, Message message) throws Exception {
        try {
            DefaultValidationErrorHandler errorHandler = new DefaultValidationErrorHandler();
            Schema schema = this.getSchema(message);
            DocumentBuilder db = XmlSignatureHelper.newDocumentBuilder(this.getConfiguration().getDisallowDoctypeDecl(), schema);
            db.setErrorHandler((ErrorHandler)errorHandler);
            Document doc = db.parse(is);
            errorHandler.handleErrors(message.getExchange(), schema, null);
            return doc;
        }
        catch (SAXException e) {
            throw new XmlSignatureFormatException("Message has wrong format, it is not a XML signature document. Check the sent message.", e);
        }
    }

    static class CheckerInputBuilder {
        private boolean xmlSchemaValidationExecuted;
        private int totalCountOfSignatures;
        private SignedInfo signedInfo;
        private XMLSignature.SignatureValue signatureValue;
        private List<? extends XMLObject> objects;
        private Document messageBodyDocument;
        private Message message;
        private KeyInfo keyInfo;
        private Element currentSignatureElement;
        private int currentCountOfSignatures;

        CheckerInputBuilder() {
        }

        CheckerInputBuilder xmlSchemaValidationExecuted(boolean xmlSchemaValidationExecuted) {
            this.xmlSchemaValidationExecuted = xmlSchemaValidationExecuted;
            return this;
        }

        CheckerInputBuilder totalCountOfSignatures(int totalCountOfSignatures) {
            this.totalCountOfSignatures = totalCountOfSignatures;
            return this;
        }

        CheckerInputBuilder signedInfo(SignedInfo signedInfo) {
            this.signedInfo = signedInfo;
            return this;
        }

        CheckerInputBuilder signatureValue(XMLSignature.SignatureValue signatureValue) {
            this.signatureValue = signatureValue;
            return this;
        }

        CheckerInputBuilder objects(List<? extends XMLObject> objects) {
            this.objects = objects;
            return this;
        }

        CheckerInputBuilder messageBodyDocument(Document messageBodyDocument) {
            this.messageBodyDocument = messageBodyDocument;
            return this;
        }

        CheckerInputBuilder message(Message message) {
            this.message = message;
            return this;
        }

        CheckerInputBuilder keyInfo(KeyInfo keyInfo) {
            this.keyInfo = keyInfo;
            return this;
        }

        CheckerInputBuilder currentSignatureElement(Element currentSignatureElement) {
            this.currentSignatureElement = currentSignatureElement;
            return this;
        }

        CheckerInputBuilder currentCountOfSignatures(int currentCountOfSignatures) {
            this.currentCountOfSignatures = currentCountOfSignatures;
            return this;
        }

        XmlSignatureChecker.Input build() {
            return new XmlSignatureChecker.Input(){

                @Override
                public boolean isXmlSchemaValidationExecuted() {
                    return xmlSchemaValidationExecuted;
                }

                @Override
                public int getTotalCountOfSignatures() {
                    return totalCountOfSignatures;
                }

                @Override
                public SignedInfo getSignedInfo() {
                    return signedInfo;
                }

                @Override
                public XMLSignature.SignatureValue getSignatureValue() {
                    return signatureValue;
                }

                @Override
                public List<? extends XMLObject> getObjects() {
                    return objects;
                }

                @Override
                public Document getMessageBodyDocument() {
                    return messageBodyDocument;
                }

                @Override
                public Message getMessage() {
                    return message;
                }

                @Override
                public KeyInfo getKeyInfo() {
                    return keyInfo;
                }

                @Override
                public Element getCurrentSignatureElement() {
                    return currentSignatureElement;
                }

                @Override
                public int getCurrentCountOfSignatures() {
                    return currentCountOfSignatures;
                }
            };
        }
    }
}

