/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xtokenizer;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.xtokenizer.XMLTokenExpressionIterator;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.util.ObjectHelper;

@Language(value="xtokenize")
public class XMLTokenizeLanguage
extends LanguageSupport {
    private String headerName;
    private String path;
    private char mode;
    private int group;
    private Namespaces namespaces;

    public static Expression tokenize(String path) {
        return XMLTokenizeLanguage.tokenize(null, path, 'i');
    }

    public static Expression tokenize(String path, char mode) {
        return XMLTokenizeLanguage.tokenize(null, path, mode);
    }

    public static Expression tokenize(String headerName, String path) {
        return XMLTokenizeLanguage.tokenize(headerName, path, 'i');
    }

    public static Expression tokenize(String headerName, String path, char mode) {
        return XMLTokenizeLanguage.tokenize(headerName, path, mode, 1, null);
    }

    public static Expression tokenize(String headerName, String path, char mode, int group, Namespaces namespaces) {
        XMLTokenizeLanguage language = new XMLTokenizeLanguage();
        language.setHeaderName(headerName);
        language.setMode(mode);
        language.setGroup(group);
        language.setNamespaces(namespaces);
        return language.createExpression(path);
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        String path = expression != null ? expression : this.path;
        ObjectHelper.notNull((Object)path, (String)"path");
        XMLTokenExpressionIterator expr = new XMLTokenExpressionIterator(path, this.mode, this.group, this.headerName);
        if (this.namespaces != null) {
            expr.setNamespaces(this.namespaces.getNamespaces());
        }
        return expr;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public char getMode() {
        return this.mode;
    }

    public void setMode(char mode) {
        this.mode = mode;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public boolean isSingleton() {
        return false;
    }
}

