/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.apacheimpl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public final class ApacheCodecRecycler {
    protected static final DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    protected static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    protected static final ThreadLocal<SoftReference<ApacheCodecRecycler>> _recycler = new ThreadLocal();
    private BinaryDecoder decoder;
    private BinaryEncoder encoder;

    private ApacheCodecRecycler() {
    }

    public static BinaryDecoder decoder(InputStream in, boolean buffering) {
        BinaryDecoder prev = ApacheCodecRecycler._recycler().claimDecoder();
        return buffering ? DECODER_FACTORY.binaryDecoder(in, prev) : DECODER_FACTORY.directBinaryDecoder(in, prev);
    }

    public static BinaryDecoder decoder(byte[] buffer, int offset, int len) {
        BinaryDecoder prev = ApacheCodecRecycler._recycler().claimDecoder();
        return DECODER_FACTORY.binaryDecoder(buffer, offset, len, prev);
    }

    public static BinaryEncoder encoder(OutputStream out, boolean buffering) {
        BinaryEncoder prev = ApacheCodecRecycler._recycler().claimEncoder();
        return buffering ? ENCODER_FACTORY.binaryEncoder(out, prev) : ENCODER_FACTORY.directBinaryEncoder(out, prev);
    }

    public static void release(BinaryDecoder dec) {
        ApacheCodecRecycler._recycler().decoder = dec;
    }

    public static void release(BinaryEncoder enc) {
        ApacheCodecRecycler._recycler().encoder = enc;
    }

    private static ApacheCodecRecycler _recycler() {
        ApacheCodecRecycler r;
        SoftReference<ApacheCodecRecycler> ref = _recycler.get();
        ApacheCodecRecycler apacheCodecRecycler = r = ref == null ? null : ref.get();
        if (r == null) {
            r = new ApacheCodecRecycler();
            _recycler.set(new SoftReference<ApacheCodecRecycler>(r));
        }
        return r;
    }

    private BinaryDecoder claimDecoder() {
        BinaryDecoder d = this.decoder;
        this.decoder = null;
        return d;
    }

    private BinaryEncoder claimEncoder() {
        BinaryEncoder e = this.encoder;
        this.encoder = null;
        return e;
    }

    public static class BadSchemaException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        public BadSchemaException(String msg, Throwable src) {
            super(msg, src);
        }
    }
}

