/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.InvocationResult;
import si.mazi.rescu.oauth.RescuOAuthRequestAdapter;
import si.mazi.rescu.utils.HttpUtils;

class HttpTemplate {
    public static final String CHARSET_UTF_8 = "UTF-8";
    private final Logger log = LoggerFactory.getLogger(HttpTemplate.class);
    private final Map<String, String> defaultHttpHeaders = new HashMap<String, String>();
    private final int connTimeout;
    private final int readTimeout;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final OAuthConsumer oAuthConsumer;

    HttpTemplate(int readTimeout, String proxyHost, Integer proxyPort, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OAuthConsumer oAuthConsumer) {
        this(0, readTimeout, proxyHost, proxyPort, sslSocketFactory, hostnameVerifier, oAuthConsumer);
    }

    HttpTemplate(int connTimeout, int readTimeout, String proxyHost, Integer proxyPort, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OAuthConsumer oAuthConsumer) {
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.oAuthConsumer = oAuthConsumer;
        this.defaultHttpHeaders.put("Accept-Charset", CHARSET_UTF_8);
        this.defaultHttpHeaders.put("Accept", "application/json");
        this.defaultHttpHeaders.put("User-Agent", "ResCU JDK/6 AppleWebKit/535.7 Chrome/16.0.912.36 Safari/535.7");
        if (proxyHost == null || proxyPort == null) {
            this.proxy = Proxy.NO_PROXY;
        } else {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            this.log.info("Using proxy {}", (Object)this.proxy);
        }
    }

    HttpURLConnection send(String urlString, String requestBody, Map<String, String> httpHeaders, HttpMethod method) throws IOException {
        this.log.debug("Executing {} request at {}", (Object)method, (Object)urlString);
        this.log.trace("Request body = {}", (Object)requestBody);
        this.log.trace("Request headers = {}", httpHeaders);
        HttpTemplate.preconditionNotNull(urlString, "urlString cannot be null");
        HttpTemplate.preconditionNotNull(httpHeaders, "httpHeaders should not be null");
        int contentLength = requestBody == null ? 0 : requestBody.getBytes().length;
        HttpURLConnection connection = this.configureURLConnection(method, urlString, httpHeaders, contentLength);
        if (this.oAuthConsumer != null) {
            RescuOAuthRequestAdapter request = new RescuOAuthRequestAdapter(connection, requestBody);
            try {
                this.oAuthConsumer.sign((HttpRequest)request);
            }
            catch (OAuthException e) {
                throw new RuntimeException("OAuth error", e);
            }
        }
        if (contentLength > 0) {
            OutputStream out = connection.getOutputStream();
            out.write(requestBody.getBytes(CHARSET_UTF_8));
            out.flush();
        }
        return connection;
    }

    InvocationResult receive(HttpURLConnection connection) throws IOException {
        InputStream inputStream;
        String responseString;
        int httpStatus = connection.getResponseCode();
        this.log.debug("Request http status = {}", (Object)httpStatus);
        if (this.log.isTraceEnabled()) {
            for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                this.log.trace("Header response property: key='{}', value='{}'", (Object)entry.getKey(), entry.getValue());
            }
        }
        if ((responseString = this.readInputStreamAsEncodedString(inputStream = !HttpUtils.isErrorStatusCode(httpStatus) ? connection.getInputStream() : connection.getErrorStream(), connection)) != null && responseString.startsWith("\ufeff")) {
            responseString = responseString.substring(1);
        }
        this.log.trace("Http call returned {}; response body:\n{}", (Object)httpStatus, (Object)responseString);
        return new InvocationResult(responseString, httpStatus);
    }

    private HttpURLConnection configureURLConnection(HttpMethod method, String urlString, Map<String, String> httpHeaders, int contentLength) throws IOException {
        HttpTemplate.preconditionNotNull((Object)method, "method cannot be null");
        HttpTemplate.preconditionNotNull(urlString, "urlString cannot be null");
        HttpTemplate.preconditionNotNull(httpHeaders, "httpHeaders cannot be null");
        HttpURLConnection connection = this.getHttpURLConnection(urlString);
        connection.setRequestMethod(method.name());
        HashMap<String, String> headerKeyValues = new HashMap<String, String>(this.defaultHttpHeaders);
        headerKeyValues.putAll(httpHeaders);
        for (Map.Entry entry : headerKeyValues.entrySet()) {
            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            this.log.trace("Header request property: key='{}', value='{}'", entry.getKey(), entry.getValue());
        }
        if (contentLength > 0) {
            connection.setDoOutput(true);
            connection.setDoInput(true);
        }
        connection.setRequestProperty("Content-Length", Integer.toString(contentLength));
        return connection;
    }

    protected HttpURLConnection getHttpURLConnection(String urlString) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(urlString).openConnection(this.proxy);
        if (this.readTimeout > 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        if (this.connTimeout > 0) {
            connection.setConnectTimeout(this.connTimeout);
        }
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            if (this.sslSocketFactory != null) {
                httpsConnection.setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                httpsConnection.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readInputStreamAsEncodedString(InputStream inputStream, HttpURLConnection connection) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            String responseEncoding = this.getResponseEncoding(connection);
            if (this.izGzipped(connection)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            InputStreamReader in = responseEncoding != null ? new InputStreamReader(inputStream, responseEncoding) : new InputStreamReader(inputStream, CHARSET_UTF_8);
            reader = new BufferedReader(in);
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            inputStream.close();
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    boolean izGzipped(HttpURLConnection connection) {
        return "gzip".equalsIgnoreCase(connection.getHeaderField("Content-Encoding"));
    }

    String getResponseEncoding(URLConnection connection) {
        String charset = null;
        String contentType = connection.getHeaderField("Content-Type");
        if (contentType != null) {
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                charset = param.split("=", 2)[1];
                break;
            }
        }
        return charset;
    }

    private static void preconditionNotNull(Object what, String message) {
        if (what == null) {
            throw new NullPointerException(message);
        }
    }
}

