/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;

final class Config {
    public static final String RESCU_PROPERTIES = "rescu.properties";
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String HTTP_CONN_TIMEOUT = "rescu.http.connTimeoutMillis";
    private static final String HTTP_READ_TIMEOUT = "rescu.http.readTimeoutMillis";
    private static final String PROXY_HOST = "rescu.http.readProxyHost";
    private static final String PROXY_PORT = "rescu.http.readProxyPort";
    private static final String IGNORE_HTTP_ERROR_CODES = "rescu.http.ignoreErrorCodes";
    private static final String WRAP_UNEXPECTED_EXCEPTIONS = "rescu.http.wrapUnexpectedExceptions";
    private static final int httpConnTimeout;
    private static final int httpReadTimeout;
    private static final String proxyHost;
    private static final Integer proxyPort;
    private static final boolean ignoreHttpErrorCodes;
    private static final boolean wrapUnexpectedExceptions;

    private Config() throws InstantiationException {
        throw new InstantiationException("This class is not for instantiation");
    }

    private static boolean getBoolean(Properties properties, String key) {
        String ignoreErrorCodes = properties.getProperty(key);
        return ignoreErrorCodes != null && Boolean.parseBoolean(ignoreErrorCodes);
    }

    public static int getHttpConnTimeout() {
        return httpConnTimeout;
    }

    public static int getHttpReadTimeout() {
        return httpReadTimeout;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static Integer getProxyPort() {
        return proxyPort;
    }

    public static boolean isIgnoreHttpErrorCodes() {
        return ignoreHttpErrorCodes;
    }

    public static boolean isWrapUnexpectedExceptions() {
        return wrapUnexpectedExceptions;
    }

    static {
        Properties dfts = new Properties();
        dfts.setProperty(HTTP_CONN_TIMEOUT, "30000");
        dfts.setProperty(HTTP_READ_TIMEOUT, "30000");
        Properties properties = new Properties(dfts);
        InputStream propsStream = RestProxyFactory.class.getResourceAsStream("/rescu.properties");
        if (propsStream != null) {
            try {
                properties.load(propsStream);
                log.debug("Loaded properties from {}.", (Object)RESCU_PROPERTIES);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading rescu.properties", e);
            }
        }
        httpConnTimeout = Integer.parseInt(properties.getProperty(HTTP_CONN_TIMEOUT));
        httpReadTimeout = Integer.parseInt(properties.getProperty(HTTP_READ_TIMEOUT));
        proxyHost = properties.getProperty(PROXY_HOST);
        String proxyPortStr = properties.getProperty(PROXY_PORT);
        proxyPort = proxyPortStr == null ? null : Integer.valueOf(Integer.parseInt(proxyPortStr));
        ignoreHttpErrorCodes = Config.getBoolean(properties, IGNORE_HTTP_ERROR_CODES);
        wrapUnexpectedExceptions = Config.getBoolean(properties, WRAP_UNEXPECTED_EXCEPTIONS);
        log.debug("Configuration from rescu.properties:");
        log.debug("httpConnTimeout = {}", (Object)httpConnTimeout);
        log.debug("httpReadTimeout = {}", (Object)httpReadTimeout);
        log.debug("proxyHost = {}", (Object)proxyHost);
        log.debug("proxyPort = {}", (Object)proxyPort);
        log.debug("ignoreHttpErrorCodes = {}", (Object)ignoreHttpErrorCodes);
    }
}

