/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SqlUtcTimeDeserializer
extends JsonDeserializer<Date> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SqlUtcTimeDeserializer() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str = jp.getValueAsString();
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new InvalidFormatException(null, "Error parsing as date", (Object)str, Date.class);
        }
    }
}

