/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;

public class CurrencyPairDeserializer
extends JsonDeserializer<CurrencyPair> {
    public static CurrencyPair getCurrencyPairFromString(String currencyPairString) {
        String[] symbols;
        boolean isMixedCase;
        if (currencyPairString == null || currencyPairString.isEmpty()) {
            return null;
        }
        boolean bl = isMixedCase = currencyPairString.matches(".*[a-z]+.*") && currencyPairString.matches(".*[A-Z]+.*");
        if (!isMixedCase) {
            currencyPairString = currencyPairString.toUpperCase();
        }
        if ((symbols = currencyPairString.split("[^a-zA-Z0-9]")).length == 2) {
            return new CurrencyPair(symbols[0], symbols[1]);
        }
        if (currencyPairString.length() == 6) {
            String tradeCurrency = currencyPairString.substring(0, 3);
            String priceCurrency = currencyPairString.substring(3);
            return new CurrencyPair(tradeCurrency, priceCurrency);
        }
        int bestGuess = currencyPairString.length() / 2;
        int bestLength = 0;
        for (int i = 1; i < currencyPairString.length() - 1; ++i) {
            Currency tradeCurrency = Currency.getInstanceNoCreate(currencyPairString.substring(0, i));
            Currency priceCurrency = Currency.getInstanceNoCreate(currencyPairString.substring(i));
            if (tradeCurrency != null) {
                if (priceCurrency != null) {
                    return new CurrencyPair(tradeCurrency, priceCurrency);
                }
                if (i <= bestLength) continue;
                bestLength = i;
                bestGuess = i;
                continue;
            }
            if (priceCurrency == null || currencyPairString.length() - i <= bestLength) continue;
            bestLength = currencyPairString.length() - i;
            bestGuess = i;
        }
        String tradeCurrency = currencyPairString.substring(0, bestGuess);
        String priceCurrency = currencyPairString.substring(bestGuess);
        return new CurrencyPair(tradeCurrency, priceCurrency);
    }

    public CurrencyPair deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        String currencyPairString = node.asText();
        return CurrencyPairDeserializer.getCurrencyPairFromString(currencyPairString);
    }
}

