/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;

public final class OpenOrders
implements Serializable {
    private static final long serialVersionUID = 6641558609478576563L;
    private final List<LimitOrder> openOrders;
    private final List<? extends Order> hiddenOrders;

    public OpenOrders(List<LimitOrder> openOrders) {
        this.openOrders = openOrders;
        this.hiddenOrders = Collections.emptyList();
    }

    @JsonCreator
    public OpenOrders(@JsonProperty(value="openOrders") List<LimitOrder> openOrders, @JsonProperty(value="hiddenOrders") List<Order> hiddenOrders) {
        this.openOrders = openOrders;
        this.hiddenOrders = hiddenOrders;
    }

    public List<LimitOrder> getOpenOrders() {
        return this.openOrders;
    }

    public List<Order> getAllOpenOrders() {
        ArrayList<Order> allOpenOrders = new ArrayList<Order>(this.openOrders);
        allOpenOrders.addAll(this.hiddenOrders);
        return allOpenOrders;
    }

    public List<? extends Order> getHiddenOrders() {
        return this.hiddenOrders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.addToToString(sb, this.getOpenOrders(), "Open orders");
        this.addToToString(sb, this.getHiddenOrders(), "Hidden orders");
        return sb.toString();
    }

    private void addToToString(StringBuilder sb, List<? extends Order> orders, String description) {
        sb.append(description);
        sb.append(": ");
        if (orders.isEmpty()) {
            sb.append("None\n");
        } else {
            sb.append("\n");
            for (Order order : orders) {
                sb.append("  [order=");
                sb.append(order.toString());
                sb.append("]\n");
            }
        }
    }
}

