/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.DateUtils;

@JsonDeserialize(builder=Builder.class)
public final class Ticker
implements Serializable {
    private static final long serialVersionUID = -3247730106987193154L;
    private final CurrencyPair currencyPair;
    private final BigDecimal open;
    private final BigDecimal last;
    private final BigDecimal bid;
    private final BigDecimal ask;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal vwap;
    private final BigDecimal volume;
    private final BigDecimal quoteVolume;
    private final Date timestamp;
    private final BigDecimal bidSize;
    private final BigDecimal askSize;

    private Ticker(CurrencyPair currencyPair, BigDecimal open, BigDecimal last, BigDecimal bid, BigDecimal ask, BigDecimal high, BigDecimal low, BigDecimal vwap, BigDecimal volume, BigDecimal quoteVolume, Date timestamp, BigDecimal bidSize, BigDecimal askSize) {
        this.open = open;
        this.currencyPair = currencyPair;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.vwap = vwap;
        this.volume = volume;
        this.quoteVolume = quoteVolume;
        this.timestamp = timestamp;
        this.bidSize = bidSize;
        this.askSize = askSize;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVwap() {
        return this.vwap;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getQuoteVolume() {
        if (this.quoteVolume == null && this.volume != null && this.last != null) {
            return this.volume.multiply(this.last);
        }
        return this.quoteVolume;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getBidSize() {
        return this.bidSize;
    }

    public BigDecimal getAskSize() {
        return this.askSize;
    }

    public String toString() {
        return "Ticker [currencyPair=" + this.currencyPair + ", open=" + this.open + ", last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ",avg=" + this.vwap + ", volume=" + this.volume + ", quoteVolume=" + this.quoteVolume + ", timestamp=" + DateUtils.toMillisNullSafe(this.timestamp) + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + "]";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private CurrencyPair currencyPair;
        private BigDecimal open;
        private BigDecimal last;
        private BigDecimal bid;
        private BigDecimal ask;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal vwap;
        private BigDecimal volume;
        private BigDecimal quoteVolume;
        private Date timestamp;
        private BigDecimal bidSize;
        private BigDecimal askSize;
        private boolean isBuilt = false;

        public Ticker build() {
            this.validateState();
            Ticker ticker = new Ticker(this.currencyPair, this.open, this.last, this.bid, this.ask, this.high, this.low, this.vwap, this.volume, this.quoteVolume, this.timestamp, this.bidSize, this.askSize);
            this.isBuilt = true;
            return ticker;
        }

        private void validateState() {
            if (this.isBuilt) {
                throw new IllegalStateException("The entity has been built");
            }
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            Assert.notNull(currencyPair, "Null currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder open(BigDecimal open) {
            this.open = open;
            return this;
        }

        public Builder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        public Builder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        public Builder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        public Builder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        public Builder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        public Builder vwap(BigDecimal vwap) {
            this.vwap = vwap;
            return this;
        }

        public Builder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public Builder quoteVolume(BigDecimal quoteVolume) {
            this.quoteVolume = quoteVolume;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder bidSize(BigDecimal bidSize) {
            this.bidSize = bidSize;
            return this;
        }

        public Builder askSize(BigDecimal askSize) {
            this.askSize = askSize;
            return this;
        }
    }
}

