/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xchange.XChange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.utils.Assert;

@Component(value="xchange")
public class XChangeComponent
extends DefaultComponent {
    private XChange xchange;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XChangeConfiguration configuration = new XChangeConfiguration(this);
        configuration.setName(remaining);
        XChangeEndpoint endpoint = new XChangeEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        XChange xchange = this.createXChange(configuration);
        endpoint.setXchange(xchange);
        return endpoint;
    }

    public XChange getXChange() {
        return this.xchange;
    }

    private synchronized XChange createXChange(XChangeConfiguration configuration) {
        if (this.xchange == null) {
            Class<? extends Exchange> exchangeClass = configuration.getXChangeClass();
            Assert.notNull(exchangeClass, (String)("XChange not supported: " + configuration.getName()));
            this.xchange = new XChange(ExchangeFactory.INSTANCE.createExchange(exchangeClass));
        }
        return this.xchange;
    }
}

