/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.exceptions.ExchangeUnavailableException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.OperationTimeoutException;
import org.knowm.xchange.exceptions.OrderAmountUnderMinimumException;
import org.knowm.xchange.exceptions.OrderNotValidException;
import org.knowm.xchange.exceptions.RateLimitExceededException;

public final class BinanceErrorAdapter {
    private BinanceErrorAdapter() {
    }

    public static ExchangeException adapt(BinanceException e) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = "Operation failed without any error message";
        }
        switch (e.getCode()) {
            case -1002: {
                return new ExchangeSecurityException(message, (Throwable)e);
            }
            case -1003: {
                return new RateLimitExceededException(message, (Throwable)e);
            }
            case -2011: 
            case -2010: 
            case -1010: {
                if (e.getMessage().contains("insufficient balance")) {
                    return new FundsExceededException(e.getMessage(), (Throwable)e);
                }
                return new ExchangeException(message, (Throwable)e);
            }
            case -1013: {
                return BinanceErrorAdapter.createOrderNotValidException(message, e);
            }
            case -1016: {
                return new ExchangeUnavailableException(message, (Throwable)e);
            }
            case -1021: {
                return new OperationTimeoutException(message, (Throwable)e);
            }
            case -1121: {
                return new CurrencyPairNotValidException(message, (Throwable)e);
            }
            case -1122: {
                return new ExchangeSecurityException(message, (Throwable)e);
            }
        }
        return new ExchangeException(message, (Throwable)e);
    }

    private static ExchangeException createOrderNotValidException(String message, BinanceException e) {
        if (e.getMessage().contains("MIN_NOTIONAL")) {
            return new OrderAmountUnderMinimumException(message, (Throwable)e);
        }
        return new OrderNotValidException(message, (Throwable)e);
    }
}

