/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Properties;
import org.knowm.xchange.ExchangeSpecification;

public class AuthUtils {
    public static String getBasicAuth(String user, String pass) {
        return "Basic " + Base64.getEncoder().encodeToString((user + ":" + pass).getBytes());
    }

    public static void setApiAndSecretKey(ExchangeSpecification exchangeSpec) {
        AuthUtils.setApiAndSecretKey(exchangeSpec, null);
    }

    public static void setApiAndSecretKey(ExchangeSpecification exchangeSpec, String prefix) {
        Properties props = AuthUtils.getSecretProperties(prefix);
        if (props != null) {
            exchangeSpec.setApiKey(props.getProperty("apiKey"));
            exchangeSpec.setSecretKey(props.getProperty("secretKey"));
        }
    }

    public static Properties getSecretProperties(String prefix) {
        String resource = prefix != null ? prefix + "-secret.keys" : "secret.keys";
        InputStream inStream = AuthUtils.class.getResourceAsStream("/" + resource);
        File keyfile = new File(System.getProperty("user.home") + "/.ssh", resource);
        if (inStream == null && keyfile.isFile()) {
            try {
                inStream = new FileInputStream(keyfile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties props = null;
        if (inStream != null) {
            try {
                props = new Properties();
                props.load(inStream);
                return props;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }
}

