/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.dto.LoanOrder;
import org.knowm.xchange.dto.Order;

public final class FixedRateLoanOrder
extends LoanOrder
implements Comparable<FixedRateLoanOrder> {
    private static final long serialVersionUID = 2627042395091155053L;
    private final BigDecimal rate;

    public FixedRateLoanOrder(Order.OrderType type, String currency, BigDecimal originalAmount, int dayPeriod, String id, Date timestamp, BigDecimal rate) {
        super(type, currency, originalAmount, dayPeriod, id, timestamp);
        this.rate = rate;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    @Override
    public int compareTo(FixedRateLoanOrder fixedRateLoanOrder) {
        if (!this.getRate().equals(fixedRateLoanOrder.getRate())) {
            return this.getRate().compareTo(fixedRateLoanOrder.getRate());
        }
        return this.getDayPeriod() - fixedRateLoanOrder.getDayPeriod();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rate == null ? 0 : this.rate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedRateLoanOrder other = (FixedRateLoanOrder)obj;
        return !(this.rate == null ? other.rate != null : !this.rate.equals(other.rate));
    }
}

