/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;

public final class OrderBookUpdate
implements Serializable {
    private static final long serialVersionUID = -7283757982319511254L;
    private final LimitOrder limitOrder;
    private final BigDecimal totalVolume;

    public OrderBookUpdate(Order.OrderType type, BigDecimal volume, CurrencyPair currencyPair, BigDecimal limitPrice, Date timestamp, BigDecimal totalVolume) {
        this.limitOrder = new LimitOrder(type, volume, currencyPair, "", timestamp, limitPrice);
        this.totalVolume = totalVolume;
    }

    public LimitOrder getLimitOrder() {
        return this.limitOrder;
    }

    public BigDecimal getTotalVolume() {
        return this.totalVolume;
    }

    public String toString() {
        return "OrderBookUpdate [limitOrder=" + this.limitOrder + ", totalVolume=" + this.totalVolume + "]";
    }
}

