/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;

public final class LoanOrderBook
implements Serializable {
    private static final long serialVersionUID = -2894416631375841830L;
    private final List<FixedRateLoanOrder> fixedRateAsks;
    private final List<FixedRateLoanOrder> fixedRateBids;
    private final List<FloatingRateLoanOrder> floatingRateAsks;
    private final List<FloatingRateLoanOrder> floatingRateBids;
    private Date timestamp;

    public LoanOrderBook(Date timestamp, List<FixedRateLoanOrder> fixedRateAsks, List<FixedRateLoanOrder> fixedRateBids, List<FloatingRateLoanOrder> floatingRateAsks, List<FloatingRateLoanOrder> floatingRateBids) {
        this.timestamp = timestamp;
        this.fixedRateAsks = fixedRateAsks;
        this.fixedRateBids = fixedRateBids;
        this.floatingRateAsks = floatingRateAsks;
        this.floatingRateBids = floatingRateBids;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public List<FixedRateLoanOrder> getFixedRateAsks() {
        return this.fixedRateAsks;
    }

    public List<FixedRateLoanOrder> getFixedRateBids() {
        return this.fixedRateBids;
    }

    public List<FloatingRateLoanOrder> getFloatingRateAsks() {
        return this.floatingRateAsks;
    }

    public List<FloatingRateLoanOrder> getFloatingRateBids() {
        return this.floatingRateBids;
    }

    public void update(FixedRateLoanOrder updatedLoanOrder) {
        switch (updatedLoanOrder.getType()) {
            case ASK: {
                Iterator<FixedRateLoanOrder> it = this.fixedRateAsks.iterator();
                while (it.hasNext()) {
                    FixedRateLoanOrder order = it.next();
                    if (!order.getRate().equals(updatedLoanOrder.getRate()) || order.getDayPeriod() != updatedLoanOrder.getDayPeriod()) continue;
                    it.remove();
                    break;
                }
                this.fixedRateAsks.add(updatedLoanOrder);
                Collections.sort(this.fixedRateAsks);
                break;
            }
            case BID: {
                Iterator<FixedRateLoanOrder> it = this.fixedRateBids.iterator();
                while (it.hasNext()) {
                    FixedRateLoanOrder order = it.next();
                    if (!order.getRate().equals(updatedLoanOrder.getRate()) || order.getDayPeriod() != updatedLoanOrder.getDayPeriod()) continue;
                    it.remove();
                    break;
                }
                this.fixedRateBids.add(updatedLoanOrder);
                Collections.sort(this.fixedRateBids);
                break;
            }
        }
        this.updateTimestamp(updatedLoanOrder.getTimestamp());
    }

    public void update(FloatingRateLoanOrder updatedLoanOrder) {
        boolean rateChanged = false;
        switch (updatedLoanOrder.getType()) {
            case ASK: {
                FloatingRateLoanOrder order;
                Iterator<FloatingRateLoanOrder> it = this.floatingRateAsks.iterator();
                if (it.hasNext()) {
                    order = it.next();
                    if (order.getDayPeriod() == updatedLoanOrder.getDayPeriod()) {
                        it.remove();
                    }
                    if (!order.getRate().equals(updatedLoanOrder.getRate()) && !rateChanged) {
                        rateChanged = true;
                    }
                }
                this.floatingRateAsks.add(updatedLoanOrder);
                Collections.sort(this.floatingRateAsks);
                break;
            }
            case BID: {
                FloatingRateLoanOrder order;
                Iterator<FloatingRateLoanOrder> it = this.floatingRateBids.iterator();
                if (it.hasNext()) {
                    order = it.next();
                    if (order.getDayPeriod() == updatedLoanOrder.getDayPeriod()) {
                        it.remove();
                    }
                    if (!order.getRate().equals(updatedLoanOrder.getRate()) && !rateChanged) {
                        rateChanged = true;
                    }
                }
                this.floatingRateBids.add(updatedLoanOrder);
                Collections.sort(this.fixedRateBids);
                break;
            }
        }
        if (rateChanged) {
            for (FloatingRateLoanOrder order : this.floatingRateAsks) {
                order.setRate(updatedLoanOrder.getRate());
            }
            for (FloatingRateLoanOrder order : this.floatingRateBids) {
                order.setRate(updatedLoanOrder.getRate());
            }
        }
        this.updateTimestamp(updatedLoanOrder.getTimestamp());
    }

    private void updateTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}

