/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.service.BinanceTradeHistoryParams;
import org.knowm.xchange.binance.service.BinanceTradeServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParam;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.utils.Assert;

public class BinanceTradeService
extends BinanceTradeServiceRaw
implements TradeService {
    public BinanceTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders((OpenOrdersParams)new DefaultOpenOrdersParam());
    }

    public OpenOrders getOpenOrders(CurrencyPair pair) throws IOException {
        return this.getOpenOrders((OpenOrdersParams)new DefaultOpenOrdersParamCurrencyPair(pair));
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            List<BinanceOrder> binanceOpenOrders;
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            if (params instanceof OpenOrdersParamCurrencyPair) {
                OpenOrdersParamCurrencyPair pairParams = (OpenOrdersParamCurrencyPair)params;
                CurrencyPair pair = pairParams.getCurrencyPair();
                binanceOpenOrders = super.openOrders(pair, recvWindow, this.getTimestamp());
            } else {
                binanceOpenOrders = super.openOrders(recvWindow, this.getTimestamp());
            }
            ArrayList limitOrders = new ArrayList();
            ArrayList otherOrders = new ArrayList();
            binanceOpenOrders.forEach(binanceOrder -> {
                Order order = BinanceAdapters.adaptOrder(binanceOrder);
                if (order instanceof LimitOrder) {
                    limitOrders.add((LimitOrder)order);
                } else {
                    otherOrders.add(order);
                }
            });
            return new OpenOrders(limitOrders, otherOrders);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String placeMarketOrder(MarketOrder mo) throws IOException {
        return this.placeOrder(OrderType.MARKET, (Order)mo, null, null, null);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        OrderType type;
        TimeInForce tif = this.timeInForceFromOrder((Order)limitOrder).orElse(TimeInForce.GTC);
        if (limitOrder.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.LIMIT_MAKER)) {
            type = OrderType.LIMIT_MAKER;
            tif = null;
        } else {
            type = OrderType.LIMIT;
        }
        return this.placeOrder(type, (Order)limitOrder, limitOrder.getLimitPrice(), null, tif);
    }

    public String placeStopOrder(StopOrder order) throws IOException {
        TimeInForce tif = this.timeInForceFromOrder((Order)order).orElse(order.getLimitPrice() != null ? TimeInForce.GTC : null);
        OrderType orderType = BinanceAdapters.adaptOrderType(order);
        return this.placeOrder(orderType, (Order)order, order.getLimitPrice(), order.getStopPrice(), tif);
    }

    private Optional<TimeInForce> timeInForceFromOrder(Order order) {
        return order.getOrderFlags().stream().filter(flag -> flag instanceof TimeInForce).map(flag -> (TimeInForce)((Object)flag)).findFirst();
    }

    private String placeOrder(OrderType type, Order order, BigDecimal limitPrice, BigDecimal stopPrice, TimeInForce tif) throws IOException {
        try {
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            BinanceNewOrder newOrder = this.newOrder(order.getCurrencyPair(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), limitPrice, this.getClientOrderId(order), stopPrice, null, recvWindow, this.getTimestamp());
            return Long.toString(newOrder.orderId);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public void placeTestOrder(OrderType type, Order order, BigDecimal limitPrice, BigDecimal stopPrice) throws IOException {
        try {
            TimeInForce tif = this.timeInForceFromOrder(order).orElse(null);
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            this.testNewOrder(order.getCurrencyPair(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), limitPrice, this.getClientOrderId(order), stopPrice, null, recvWindow, this.getTimestamp());
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    private String getClientOrderId(Order order) {
        String clientOrderId = null;
        for (Order.IOrderFlags flags : order.getOrderFlags()) {
            if (!(flags instanceof BinanceOrderFlags)) continue;
            BinanceOrderFlags bof = (BinanceOrderFlags)flags;
            if (clientOrderId != null) continue;
            clientOrderId = bof.getClientId();
        }
        return clientOrderId;
    }

    public boolean cancelOrder(String orderId) {
        throw new ExchangeException("You need to provide the currency pair to cancel an order.");
    }

    public boolean cancelOrder(CancelOrderParams params) throws IOException {
        try {
            if (!(params instanceof CancelOrderByCurrencyPair) && !(params instanceof CancelOrderByIdParams)) {
                throw new ExchangeException("You need to provide the currency pair and the order id to cancel an order.");
            }
            CancelOrderByCurrencyPair paramCurrencyPair = (CancelOrderByCurrencyPair)params;
            CancelOrderByIdParams paramId = (CancelOrderByIdParams)params;
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            super.cancelOrder(paramCurrencyPair.getCurrencyPair(), BinanceAdapters.id(paramId.getOrderId()), null, null, recvWindow, this.getTimestamp());
            return true;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        try {
            Assert.isTrue((boolean)(params instanceof TradeHistoryParamCurrencyPair), (String)"You need to provide the currency pair to get the user trades.");
            TradeHistoryParamCurrencyPair pairParams = (TradeHistoryParamCurrencyPair)params;
            CurrencyPair pair = pairParams.getCurrencyPair();
            if (pair == null) {
                throw new ExchangeException("You need to provide the currency pair to get the user trades.");
            }
            Integer limit = null;
            if (params instanceof TradeHistoryParamLimit) {
                TradeHistoryParamLimit limitParams = (TradeHistoryParamLimit)params;
                limit = limitParams.getLimit();
            }
            Long fromId = null;
            if (params instanceof TradeHistoryParamsIdSpan) {
                TradeHistoryParamsIdSpan idParams = (TradeHistoryParamsIdSpan)params;
                try {
                    fromId = BinanceAdapters.id(idParams.getStartId());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                if (((TradeHistoryParamsTimeSpan)params).getStartTime() != null) {
                    startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime().getTime();
                }
                if (((TradeHistoryParamsTimeSpan)params).getEndTime() != null) {
                    endTime = ((TradeHistoryParamsTimeSpan)params).getEndTime().getTime();
                }
            }
            if (fromId != null && (startTime != null || endTime != null)) {
                throw new ExchangeException("You should either specify the id from which you get the user trades from or start and end times. If you specify both, Binance will only honour the fromId parameter.");
            }
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            List<BinanceTrade> binanceTrades = super.myTrades(pair, limit, startTime, endTime, fromId, recvWindow, this.getTimestamp());
            List trades = binanceTrades.stream().map(t -> new UserTrade.Builder().type(BinanceAdapters.convertType(t.isBuyer)).originalAmount(t.qty).currencyPair(pair).price(t.price).timestamp(t.getTime()).id(Long.toString(t.id)).orderId(Long.toString(t.orderId)).feeAmount(t.commission).feeCurrency(Currency.getInstance((String)t.commissionAsset)).build()).collect(Collectors.toList());
            long lastId = binanceTrades.stream().map(t -> t.id).max(Long::compareTo).orElse(0L);
            return new UserTrades(trades, lastId, Trades.TradeSortType.SortByTimestamp);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new BinanceTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) {
        throw new NotAvailableFromExchangeException();
    }

    public Collection<Order> getOrder(OrderQueryParams ... params) throws IOException {
        try {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (OrderQueryParams param : params) {
                if (!(param instanceof OrderQueryParamCurrencyPair)) {
                    throw new ExchangeException("Parameters must be an instance of OrderQueryParamCurrencyPair");
                }
                OrderQueryParamCurrencyPair orderQueryParamCurrencyPair = (OrderQueryParamCurrencyPair)param;
                if (orderQueryParamCurrencyPair.getCurrencyPair() == null || orderQueryParamCurrencyPair.getOrderId() == null) {
                    throw new ExchangeException("You need to provide the currency pair and the order id to query an order.");
                }
                orders.add(BinanceAdapters.adaptOrder(super.orderStatus(orderQueryParamCurrencyPair.getCurrencyPair(), BinanceAdapters.id(orderQueryParamCurrencyPair.getOrderId()), null, (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow"), this.getTimestamp())));
            }
            return orders;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    static final class ClientIdFlag
    implements BinanceOrderFlags {
        private final String clientId;

        @ConstructorProperties(value={"clientId"})
        public ClientIdFlag(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public String getClientId() {
            return this.clientId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientIdFlag)) {
                return false;
            }
            ClientIdFlag other = (ClientIdFlag)o;
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        public String toString() {
            return "BinanceTradeService.ClientIdFlag(clientId=" + this.getClientId() + ")";
        }
    }

    public static interface BinanceOrderFlags
    extends Order.IOrderFlags {
        public static BinanceOrderFlags withClientId(String clientId) {
            return new ClientIdFlag(clientId);
        }

        public String getClientId();
    }
}

