/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.service.BinanceAccountServiceRaw;
import org.knowm.xchange.binance.service.BinanceFundingHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BinanceAccountService
extends BinanceAccountServiceRaw
implements AccountService {
    public BinanceAccountService(Exchange exchange) {
        super(exchange);
    }

    private static FundingRecord.Status withdrawStatus(int status) {
        switch (status) {
            case 0: 
            case 2: 
            case 4: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.CANCELLED;
            }
            case 3: 
            case 5: {
                return FundingRecord.Status.FAILED;
            }
            case 6: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance withdraw status: " + status);
    }

    private static FundingRecord.Status depositStatus(int status) {
        switch (status) {
            case 0: 
            case 6: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance deposit status: " + status);
    }

    private BinanceAccountInformation getBinanceAccountInformation() throws IOException {
        return super.account(this.getRecvWindow(), this.getTimestamp());
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            BinanceAccountInformation acc = this.getBinanceAccountInformation();
            List balances = acc.balances.stream().map(b -> new Balance(b.getCurrency(), b.getTotal(), b.getAvailable())).collect(Collectors.toList());
            return new AccountInfo(new Date(acc.updateTime), new Wallet[]{Wallet.Builder.from(balances).build()});
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        BinanceAccountInformation acc = this.getBinanceAccountInformation();
        BigDecimal makerFee = acc.makerCommission.divide(new BigDecimal("10000"), 4, RoundingMode.UNNECESSARY);
        BigDecimal takerFee = acc.takerCommission.divide(new BigDecimal("10000"), 4, RoundingMode.UNNECESSARY);
        HashMap<CurrencyPair, Fee> tradingFees = new HashMap<CurrencyPair, Fee>();
        List pairs = this.exchange.getExchangeSymbols();
        pairs.forEach(pair -> tradingFees.put((CurrencyPair)pair, new Fee(makerFee, takerFee)));
        return tradingFees;
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return super.withdraw(currency.getCurrencyCode(), address, amount);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, AddressWithTag address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            if (!(params instanceof DefaultWithdrawFundsParams)) {
                throw new IllegalArgumentException("DefaultWithdrawFundsParams must be provided.");
            }
            String id = null;
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams rippleParams = null;
                rippleParams = (RippleWithdrawFundsParams)params;
                id = super.withdraw(rippleParams.getCurrency().getCurrencyCode(), rippleParams.getAddress(), rippleParams.getTag(), rippleParams.getAmount());
            } else {
                DefaultWithdrawFundsParams p = (DefaultWithdrawFundsParams)params;
                id = super.withdraw(p.getCurrency().getCurrencyCode(), p.getAddress(), p.getAddressTag(), p.getAmount());
            }
            return id;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return super.requestDepositAddress((Currency)currency).address;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        DepositAddress depositAddress = super.requestDepositAddress(currency);
        String destinationTag = depositAddress.addressTag == null || depositAddress.addressTag.isEmpty() ? null : depositAddress.addressTag;
        return new AddressWithTag(depositAddress.address, destinationTag);
    }

    public Map<String, AssetDetail> getAssetDetails() throws IOException {
        try {
            return super.requestAssetDetail().getAssetDetail();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BinanceFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            HistoryParamsFundingType f;
            TradeHistoryParamCurrency cp;
            String asset = null;
            if (params instanceof TradeHistoryParamCurrency && (cp = (TradeHistoryParamCurrency)params).getCurrency() != null) {
                asset = cp.getCurrency().getCurrencyCode();
            }
            Integer limit = null;
            if (params instanceof TradeHistoryParamLimit) {
                TradeHistoryParamLimit hpl = (TradeHistoryParamLimit)params;
                limit = hpl.getLimit();
            }
            boolean withdrawals = true;
            boolean deposits = true;
            boolean otherInflow = true;
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                TradeHistoryParamsTimeSpan tp = (TradeHistoryParamsTimeSpan)params;
                if (tp.getStartTime() != null) {
                    startTime = tp.getStartTime().getTime();
                }
                if (tp.getEndTime() != null) {
                    endTime = tp.getEndTime().getTime();
                }
            }
            if (params instanceof HistoryParamsFundingType && (f = (HistoryParamsFundingType)params).getType() != null) {
                withdrawals = f.getType() == FundingRecord.Type.WITHDRAWAL;
                deposits = f.getType() == FundingRecord.Type.DEPOSIT;
                otherInflow = f.getType() == FundingRecord.Type.OTHER_INFLOW;
            }
            ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
            if (withdrawals) {
                super.withdrawHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestamp()).forEach(w -> result.add(new FundingRecord(w.getAddress(), w.getAddressTag(), new Date(w.getApplyTime()), Currency.getInstance((String)w.getAsset()), w.getAmount(), w.getId(), w.getTxId(), FundingRecord.Type.WITHDRAWAL, BinanceAccountService.withdrawStatus(w.getStatus()), null, w.getTransactionFee(), null)));
            }
            if (deposits) {
                super.depositHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestamp()).forEach(d -> result.add(new FundingRecord(d.getAddress(), d.getAddressTag(), new Date(d.getInsertTime()), Currency.getInstance((String)d.getAsset()), d.getAmount(), null, d.getTxId(), FundingRecord.Type.DEPOSIT, BinanceAccountService.depositStatus(d.getStatus()), null, null, null)));
            }
            if (otherInflow) {
                super.getAssetDividend(asset, startTime, endTime).forEach(a -> result.add(new FundingRecord(null, null, new Date(a.getDivTime()), Currency.getInstance((String)a.getAsset()), a.getAmount(), null, String.valueOf(a.getTranId()), FundingRecord.Type.OTHER_INFLOW, FundingRecord.Status.COMPLETE, null, null, a.getEnInfo())));
            }
            return result;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }
}

