/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.xchange.XChangeComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;

@UriParams
public class XChangeConfiguration {
    public static final String HEADER_CURRENCY = "Currency";
    public static final String HEADER_CURRENCY_PAIR = "CurrencyPair";
    static Map<String, Class<? extends Exchange>> xchangeMapping = new HashMap<String, Class<? extends Exchange>>();
    @UriPath(description="The exchange to connect to")
    @Metadata(required=true)
    private String name;
    @UriParam(description="The service to call")
    @Metadata(required=true)
    private XChangeService service;
    @UriParam(description="The method to execute")
    @Metadata(required=true)
    private XChangeMethod method;
    @UriParam(description="The currency")
    private Currency currency;
    @UriParam(description="The currency pair")
    private String currencyPair;

    public XChangeConfiguration(XChangeComponent component) {
        ObjectHelper.notNull((Object)((Object)component), (String)"component");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XChangeService getService() {
        return this.service;
    }

    public void setService(XChangeService service) {
        this.service = service;
    }

    public XChangeMethod getMethod() {
        return this.method;
    }

    public void setMethod(XChangeMethod method) {
        this.method = method;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setCurrency(String curr) {
        this.currency = Currency.getInstanceNoCreate((String)curr);
    }

    public CurrencyPair getAsCurrencyPair() {
        if (this.currencyPair != null) {
            return new CurrencyPair(this.currencyPair);
        }
        return null;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public void setCurrencyPair(String currencyPair) {
        this.currencyPair = currencyPair;
    }

    public Class<? extends Exchange> getXChangeClass() {
        Class<Object> xchangeClass = xchangeMapping.get(this.name);
        if (xchangeClass == null) {
            String firstUpper = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
            String className = "org.knowm.xchange." + this.name + "." + firstUpper + "Exchange";
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                xchangeClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return xchangeClass;
    }

    public Set<String> getSupportedXChangeNames() {
        return xchangeMapping.keySet();
    }

    public static enum XChangeMethod {
        balances,
        fundingHistory,
        wallets,
        currencies,
        currencyMetaData,
        currencyPairs,
        currencyPairMetaData,
        ticker;

    }

    public static enum XChangeService {
        marketdata,
        metadata,
        account;

    }
}

