/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.AnnotationUtils;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.RestInvocation;

public class RestMethodMetadata
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RestMethodMetadata.class);
    private static final List<Class<? extends Annotation>> HTTP_METHOD_ANNS = Arrays.asList(GET.class, POST.class, PUT.class, OPTIONS.class, HEAD.class, DELETE.class, PATCH.class);
    private final Type returnType;
    private final HttpMethod httpMethod;
    private final String baseUrl;
    private final String intfacePath;
    private final String methodPathTemplate;
    private final Class<? extends RuntimeException> exceptionType;
    private final String reqContentType;
    private final String resContentType;
    private final String methodName;
    private final Map<Class<? extends Annotation>, Annotation> methodAnnotationMap;
    private final Annotation[][] parameterAnnotations;

    public RestMethodMetadata(Type returnType, HttpMethod httpMethod, String baseUrl, String intfacePath, String methodPathTemplate, Class<? extends RuntimeException> exceptionType, String reqContentType, String resContentType, String methodName, Map<Class<? extends Annotation>, Annotation> methodAnnotationMap, Annotation[][] parameterAnnotations) {
        this.returnType = returnType;
        this.httpMethod = httpMethod;
        this.baseUrl = baseUrl;
        this.intfacePath = intfacePath;
        this.reqContentType = reqContentType;
        this.resContentType = resContentType;
        this.methodName = methodName;
        this.methodAnnotationMap = methodAnnotationMap;
        this.parameterAnnotations = parameterAnnotations;
        this.methodPathTemplate = methodPathTemplate == null ? "" : methodPathTemplate;
        this.exceptionType = exceptionType;
    }

    public static RestMethodMetadata create(Method method, String baseUrl, String intfacePath) {
        String methodName = method.getName();
        Map<Class<? extends Annotation>, Annotation> methodAnnotationMap = AnnotationUtils.getMethodAnnotationMap(method, RestInvocation.PARAM_ANNOTATION_CLASSES);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Consumes consumes = AnnotationUtils.getFromMethodOrClass(method, Consumes.class);
        String reqContentType = consumes != null ? consumes.value()[0] : null;
        Produces produces = AnnotationUtils.getFromMethodOrClass(method, Produces.class);
        String resContentType = produces != null ? produces.value()[0] : null;
        Path pathAnn = method.getAnnotation(Path.class);
        String methodPathTemplate = pathAnn == null ? "" : pathAnn.value();
        HttpMethod httpMethod = RestMethodMetadata.getHttpMethod(method);
        Class<?>[] thrownExceptions = method.getExceptionTypes();
        Class<?> exceptionType = null;
        for (Class<?> thrownException : thrownExceptions) {
            if (IOException.class.isAssignableFrom(thrownException)) continue;
            if (!RuntimeException.class.isAssignableFrom(thrownException)) {
                throw new IllegalArgumentException("Only IOExceptions and RuntimeExceptions are supported on API methods; this method doesn't comply: " + method);
            }
            if (exceptionType != null) {
                throw new IllegalArgumentException("At most one RuntimeException is supported on an API method; this method has more: " + method);
            }
            exceptionType = thrownException;
        }
        if (consumes != null && Arrays.asList(HttpMethod.DELETE, HttpMethod.GET).contains((Object)httpMethod)) {
            log.warn("{} request declared as consuming method body as {}. While body is allowed, it should be ignored by the server. Is this intended? Method: {}", new Object[]{httpMethod, reqContentType, method});
        }
        return new RestMethodMetadata(method.getGenericReturnType(), httpMethod, baseUrl, intfacePath, methodPathTemplate, exceptionType, reqContentType, resContentType, methodName, methodAnnotationMap, parameterAnnotations);
    }

    static HttpMethod getHttpMethod(Method method) {
        HttpMethod httpMethod = null;
        for (Class<? extends Annotation> m : HTTP_METHOD_ANNS) {
            if (!method.isAnnotationPresent(m)) continue;
            if (httpMethod != null) {
                throw new IllegalArgumentException("Method is annotated with more than one HTTP-method annotation: " + method);
            }
            httpMethod = HttpMethod.valueOf(m.getSimpleName());
        }
        if (httpMethod == null) {
            throw new IllegalArgumentException("Method must be annotated with a HTTP-method annotation: " + method);
        }
        return httpMethod;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getIntfacePath() {
        return this.intfacePath;
    }

    public String getMethodPathTemplate() {
        return this.methodPathTemplate;
    }

    public Class<? extends RuntimeException> getExceptionType() {
        return this.exceptionType;
    }

    public String getReqContentType() {
        return this.reqContentType;
    }

    public String getResContentType() {
        return this.resContentType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Map<Class<? extends Annotation>, Annotation> getMethodAnnotationMap() {
        return this.methodAnnotationMap;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations;
    }
}

